package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import android.content.Context;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.DeputyUnitBean;
import com.gingersoft.supply_chain.mvp.bean.DishDetailBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseWarehousingOrderDetailsVO;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author zjs.
 * 菜品食材綁定列表
 */
public class DishDetailAdapter extends BaseQuickAdapter<DishDetailBean, BaseViewHolder> {

    private Context context;
    private int[] colors = new int[]{R.color.color_f9, R.color.white};

    public DishDetailAdapter(Context context, List<DishDetailBean> foods) {
        super(R.layout.item_dishes_foods,foods);
        this.context = context;
        addChildClickViewIds(R.id.tv_dishes_unit,R.id.tv_dishes_del);
        // TODO: 2021/7/25   扶單位處理
    }


    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, DishDetailBean item) {
        viewHolder.setText(R.id.tv_dishes_name, item.getFoodName());//食材名字
        viewHolder.setText(R.id.tv_dishes_unit, item.getBasicUnitName());//配置的單位

//        viewHolder.setText(R.id.tv_dishes_unit, item.getUnitName());
        List<DeputyUnitBean> deputyUnitBeans= item.getFoodUnits();//副單位
        if (CollectionUtils.isNullOrEmpty(deputyUnitBeans)) {
//            addChildClickViewIds(R.id.tv_dishes_unit); consumeQuantity
        }
        viewHolder.setText(R.id.tv_dishes_count, String.valueOf(item.getConsumeQuantity()));//消耗數量
    }

}
