package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import com.chad.library.adapter.base.entity.node.BaseExpandNode;
import com.chad.library.adapter.base.entity.node.BaseNode;
import com.gingersoft.gsa.cloud.common.utils.log.LogUtil;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class DishesGroupNode extends BaseExpandNode{
    private int id;
    private int parentId;
    private int restaurantId;
    private boolean isParent;
    private int seqNo;
    private String foodName;
    //子项目项目选中
    private int pos;

    private List<DishNode> child;
    private List<BaseNode> childNode;

    public int getPos() {
        return pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public List<DishNode> getDishNodes() {
        return child;
    }

    public void setDishNodes(List<DishNode> dishNodes) {
        this.child = dishNodes;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getParentId() {
        return parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public int getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(int restaurantId) {
        this.restaurantId = restaurantId;
    }

    public boolean isParent() {
        return isParent;
    }

    public void setParent(boolean parent) {
        isParent = parent;
    }

    public int getSeqNo() {
        return seqNo;
    }

    public void setSeqNo(int seqNo) {
        this.seqNo = seqNo;
    }

    public String getFoodName() {
        return foodName;
    }

    public void setFoodName(String foodName) {
        this.foodName = foodName;
    }

    public void setChildNode(List<BaseNode> childNode) {
        this.childNode = childNode;
    }

    public DishesGroupNode(List<BaseNode> childNode) {
        this.childNode = childNode;
        setExpanded(false);
    }
    public void addChildNode(BaseNode baseNode) {
        if (baseNode == null) {
            return;
        }
        if (childNode == null) {
            childNode = new ArrayList<>();
        }
        childNode.add(baseNode);
    }

    public String getTitle() {
        return foodName;
    }

    @Nullable
    @Override
    public List<BaseNode> getChildNode() {
        if (childNode == null) {
            childNode=new ArrayList<>();
        }
        if ( child != null) {
            childNode.clear();
            childNode.addAll(child);
        }
        return childNode;
    }

}
