package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import com.chad.library.adapter.base.BaseNodeAdapter;
import com.chad.library.adapter.base.entity.node.BaseNode;
import com.gingersoft.supply_chain.R;

import org.jetbrains.annotations.NotNull;

import java.util.List;

public class DishesTreeAdapter extends BaseNodeAdapter {
    public static final  int DISHESGROUP=1;
    public static final  int DISHESSINGLE=2;
    public DishesTreeAdapter(DishesGroupProvider.defaultClick defaultClick) {
        super();
        DishesGroupProvider groupProvider= new DishesGroupProvider();
        groupProvider.setDefaultClick(defaultClick);
        addNodeProvider(groupProvider);
        addNodeProvider(new DishProvider());
        addChildClickViewIds(R.id.tv_dish_title);
    }
    @Override
    protected int getItemType(@NotNull List<? extends BaseNode> list, int i) {
        BaseNode node = list.get(i);
        if (node instanceof DishesGroupNode) {
            return DISHESGROUP;
        } else if (node instanceof DishNode) {
            return DISHESSINGLE;
        }
        return -1;
 
    }
    public static final int EXPAND_COLLAPSE_PAYLOAD = 110;
}