package com.gingersoft.supply_chain.mvp.ui.fragment.food;

import android.view.View;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.BuyIngredientsBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.gingersoft.supply_chain.mvp.ui.widget.GoodsDetailsPopup;
import java.util.List;

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/5/7
 * Time: 16:07
 * Use: 食材管理
 */
public class FoodManagementFragment extends BuyIngredientsFragment {

    public static FoodManagementFragment newInstance() {
        return new FoodManagementFragment();
    }

    @Override
    protected void initPage() {
        super.initPage();
        layoutFoodIngredientsBtn.setVisibility(View.GONE);
        btnNewFoodIngredient.setVisibility(View.VISIBLE);
        layoutChooseSize.setVisibility(View.GONE);
    }

    @Override
    protected void initTopBar() {
        initTopBar(topbarFoodIngredients, "食材管理");
        topbarFoodIngredients.addRightImageButton(R.drawable.ic_circle_new_food_ingredient, R.id.qmui_add_new_food_ingredients).setOnClickListener(v -> {
            //新增食材
            toCreateFood();
        });
    }

    @Override
    public void initCategoryInfo(List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTrees) {
        super.initCategoryInfo(foodCategoryTrees);
        if (firstLevelCategoryAdapter != null) {
            firstLevelCategoryAdapter.setIsShowNumber(false);
        }
    }

    @Override
    public void loadFood(List<BuyIngredientsBean> buyIngredientsBeans, boolean addToHead, boolean isReset) {
        super.loadFood(buyIngredientsBeans, addToHead, isReset);
        if (adapter != null) {
            adapter.setEdit(true).setShowNumber(false);
        }
    }

    @Override
    protected GoodsDetailsPopup getFoodDetailsPopup(PurchaseFoodBean purchaseFoodBean) {
        return new GoodsDetailsPopup(requireContext(), purchaseFoodBean).setEditNumber(false);
    }
}
