package com.gingersoft.supply_chain.mvp.ui.fragment.food;

import android.os.Bundle;
import android.view.View;

import androidx.fragment.app.Fragment;

import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.WarehousingOrderDetailsFragment;

import java.util.List;

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/5/7
 * Time: 16:32
 * Use:入庫單選購食材頁面
 */
public class FoodWarehousingFragment extends BuyIngredientsFragment {

    public static FoodWarehousingFragment newInstance() {
        return new FoodWarehousingFragment();
    }

    @Override
    protected void initPage() {
        super.initPage();
        layoutChooseSize.setVisibility(View.VISIBLE);
        btnFoodIngredientsCancel.setVisibility(View.GONE);
    }

    @Override
    protected void confirm() {
        List<PurchaseFoodBean> purchaseFood = mPresenter.getPurchaseFood();
        if (CollectionUtils.isNotNullOrEmpty(purchaseFood)) {
            //採購入庫單
            setFragmentResult(RESULT_OK, null);
            List<Fragment> fragments = requireActivity().getSupportFragmentManager().getFragments();
            for (Fragment fragment : fragments) {
                if (fragment instanceof WarehousingOrderDetailsFragment) {
                    //有入庫單詳情
                    killMyself();
                    return;
                }
            }
            //沒入庫單詳情
            startWithPop(WarehousingOrderDetailsFragment.newInstance(-1, ""));
        } else {
            showMessage("請選擇食材");
        }
    }
}
