package com.gingersoft.supply_chain.mvp.ui.fragment.food;

import android.os.Bundle;
import android.view.View;

import com.gingersoft.gsa.cloud.common.loadsir.purchase.NotGoodsCallback;
import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.BuyIngredientsBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;

import java.util.Collections;
import java.util.List;

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/5/7
 * Time: 16:13
 * Use:
 */
public class SupplierFoodFragment extends BuyIngredientsFragment {

    private final static String supplierIdKey = "supplierId";
    private final static String supplierNameKey = "supplierName";

    public static SupplierFoodFragment newInstance(int supplierId, String supplierName) {
        SupplierFoodFragment fragment = new SupplierFoodFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(supplierIdKey, supplierId);
        bundle.putString(supplierNameKey, supplierName);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    protected void loadDataByType() {
        Bundle arguments = getArguments();
        if (arguments != null) {
            int supplierId = arguments.getInt(supplierIdKey);
            String supplierName = arguments.getString(supplierNameKey);
            //設置標題為這個供應商名字
            topbarFoodIngredients.setTitle(supplierName);
            //設置左側顯示數據
            OrderCategoryBean.FoodCategoryTrees supplierToCategory = new OrderCategoryBean.FoodCategoryTrees(supplierId, supplierName, 0);
            //只顯示一個供應商信息，所以隱藏左邊側邊欄
            layoutIngredientsLeft.setVisibility(View.GONE);
            //將顯示模式設置為顯示供應商
            isShowSupplier = true;
            //隱藏二級分類
            layoutCategory.setVisibility(View.GONE);
            mPresenter.initSupplierFoods(1);
            //在一級分類中加載食品信息
            initCategoryInfo(Collections.singletonList(supplierToCategory));
        } else {
            killMyself();
        }
    }

    @Override
    protected void setSecondCategoryShowState(int visibility) {
        layoutCategory.setVisibility(View.GONE);
    }

    @Override
    protected void initTopBar() {
        initTopBar(topbarFoodIngredients, "食材管理");
        topbarFoodIngredients.addRightImageButton(R.drawable.ic_circle_new_food_ingredient, R.id.qmui_add_new_food_ingredients).setOnClickListener(v -> {
            //新增食材
            toCreateFood();
        });
    }

    @Override
    protected void refreshData() {
        mPresenter.getFoodsBySupplier(edFoodIngredientsSearch.getText().toString(),0, firstLevelCategoryAdapter.getItem(0), false, true);
    }

    @Override
    public void initCategoryInfo(List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTrees) {
        super.initCategoryInfo(foodCategoryTrees);
        if (firstLevelCategoryAdapter != null) {
            firstLevelCategoryAdapter.setIsShowNumber(false);
        }
    }

    @Override
    public void loadFood(List<BuyIngredientsBean> buyIngredientsBeans, boolean addToHead, boolean isReset) {
        setRefreshState(false);
        if (buyIngredientsBeans == null || CollectionUtils.isNullOrEmpty(buyIngredientsBeans.get(0).purchaseFoodList)) {
            //如果是單個供應商，需要判斷食材是不是為空
            fullRegister.showCallback(NotGoodsCallback.class);
            return;
        }
        super.loadFood(buyIngredientsBeans, addToHead, isReset);
        if (adapter != null) {
            adapter.setEdit(true).setShowNumber(true);
        }
    }
}
