package com.gingersoft.supply_chain.mvp.ui.fragment.order;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerConfirmOrderComponent;
import com.gingersoft.supply_chain.mvp.bean.ConfirmOrderBean;
import com.gingersoft.supply_chain.mvp.contract.ConfirmOrderContract;
import com.gingersoft.supply_chain.mvp.presenter.ConfirmOrderPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.ConfirmOrderAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;


/**
 * ================================================
 * Description:確認訂單頁面 * <p>
 * Created by MVPArmsTemplate on 12/17/2020 10:24
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class ConfirmOrderFragment extends BaseSupplyChainFragment<ConfirmOrderPresenter> implements ConfirmOrderContract.View {

    @BindView(R2.id.supply_top_bar)
    QMUITopBar supplyTopBar;
    @BindView(R2.id.rv_confirm_order)
    RecyclerView rvConfirmOrder;
    @BindView(R2.id.btn_confirm_order)
    QMUIAlphaTextView btnConfirmOrder;
    @BindView(R2.id.btn_cancel_order)
    QMUIAlphaTextView btnCancelOrder;

    public static ConfirmOrderFragment newInstance() {
        ConfirmOrderFragment fragment = new ConfirmOrderFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerConfirmOrderComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_confirm_order, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar(supplyTopBar, "採購單確認");
        mPresenter.organizeShopCartData();
    }

    @OnClick({R2.id.btn_confirm_order, R2.id.btn_cancel_order})
    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.btn_confirm_order) {
            //確認訂單
            mPresenter.addPurchaseOrder();
        } else if (viewId == R.id.btn_cancel_order) {
            killMyself();
        }
    }

    @Override
    public void loadInfo(List<ConfirmOrderBean> confirmOrderBeans) {
        ConfirmOrderAdapter adapter = new ConfirmOrderAdapter();
        rvConfirmOrder.setAdapter(adapter);
        adapter.setList(confirmOrderBeans);
    }

    @Override
    public void addOrderSuccess(List<ConfirmOrderBean.PurchaseOrder> purchaseOrders) {
        ShoppingCatFragment childFragment = findChildFragment(ShoppingCatFragment.class);
        if (childFragment != null) {
            childFragment.killMyself();
        }
        startWithPop(SendMsgFragment.newInstance(purchaseOrders));
    }
}
