package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseBinderAdapter;
import com.gingersoft.gsa.cloud.common.loadsir.EmptyCallback;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerSnInOutboundRecordsComponent;
import com.gingersoft.supply_chain.mvp.contract.SnInOutboundRecordsContract;
import com.gingersoft.supply_chain.mvp.presenter.SnInOutboundRecordsPresenter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.jess.arms.di.component.AppComponent;
import com.kingja.loadsir.core.LoadSir;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

import butterknife.BindView;
import butterknife.OnClick;


/**
 * SN碼出入庫記錄頁面
 *
 * @author admin
 */
public class SnInOutboundRecordsFragment extends BaseSupplyChainFragment<SnInOutboundRecordsPresenter> implements SnInOutboundRecordsContract.View, View.OnClickListener {

    @BindView(R2.id.supply_top_bar)
    QMUITopBar supplyTopBar;
    @BindView(R2.id.ed_inout_bound_search)
    EditText edInoutBoundSearch;
    @BindView(R2.id.btn_inout_bound_record_search)
    QMUIAlphaButton btnInoutBoundRecordSearch;
    @BindView(R2.id.rv_inout_bound_record_list)
    RecyclerView rvInoutBoundRecordList;
//    @BindView(R2.id.srl_inout_bound_record)
//    SmartRefreshLayout srlInoutBoundRecord;

    public static SnInOutboundRecordsFragment newInstance() {
        SnInOutboundRecordsFragment fragment = new SnInOutboundRecordsFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerSnInOutboundRecordsComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_inout_bound_records_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        loadService = LoadSir.getDefault().register(rvInoutBoundRecordList);
//        srlInoutBoundRecord.setPrimaryColorsId(R.color.trans, R.color.black);
        edInoutBoundSearch.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_SEARCH) {
                hideSoftInput();
                mPresenter.getFoodInOutBoundRecordBySnCode(edInoutBoundSearch.getText().toString());
            }
            return false;
        });
        initTopBar(supplyTopBar, getString(R.string.str_title_sn_query));
    }

    @Override
    protected void initTopBar(QMUITopBar topBar, String title) {
        if (topBar.getLeftViewList().size() <= 0) {
            topBar.setTitle(title);
            topBar.addLeftBackImageButton().setOnClickListener(v -> {
                if (mPresenter.goBack()) {
                }else {
                   killMyself();
                }
            });
        }
    }

    @OnClick({R2.id.btn_inout_bound_record_search})
    @Override
    public void onClick(View v) {
        int vId = v.getId();
        if (vId == R.id.btn_inout_bound_record_search) {
            //搜索
            mPresenter.getFoodInOutBoundRecordBySnCode(edInoutBoundSearch.getText().toString());
        }
    }

    @Override
    public void showEmpty() {
        loadService.showCallback(EmptyCallback.class);
    }

    @Override
    public void loadAdapter(BaseBinderAdapter baseBinderAdapter) {
        loadService.showSuccess();
        rvInoutBoundRecordList.setAdapter(baseBinderAdapter);
    }
}
