package com.gingersoft.gsa.cloud.common.config.globalconfig.applyOptions;

import android.content.Context;

import androidx.annotation.NonNull;

import com.gingersoft.gsa.cloud.common.config.OkHttpConfig;
import com.jess.arms.di.module.ClientModule;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.Nullable;

import me.jessyan.progressmanager.ProgressManager;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.Handshake;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;

/**
 * autour: 宁斌
 * date: 2018/4/3 14:47
 * update: 2018/4/3 14:47
 * description:
 */

public class MyOkhttpConfiguration implements ClientModule.OkhttpConfiguration {

    @Override
    public void configOkhttp(Context context, OkHttpClient.Builder builder) {
//        builder.sslSocketFactory(); //支持 Https,详情请百度
        builder.connectTimeout(OkHttpConfig.CONNECT_TIMEOUT, TimeUnit.SECONDS);
        builder.writeTimeout(OkHttpConfig.REQUEST_TIMEOUT, TimeUnit.SECONDS);
        builder.readTimeout(OkHttpConfig.REQUEST_TIMEOUT, TimeUnit.SECONDS);
        builder.cache(new Cache(new File(OkHttpConfig.CACHE_DIRECTORY), OkHttpConfig.CACHE_MAXSIZE));
        //使用一行代码监听 Retrofit／Okhttp 上传下载进度监听,以及 Glide 加载进度监听 详细使用方法查看 https://github.com/JessYanCoding/ProgressManager
        ProgressManager.getInstance().with(builder);
        //让 Retrofit 同时支持多个 BaseUrl 以及动态改变 BaseUrl. 详细使用请方法查看 https://github.com/JessYanCoding/RetrofitUrlManager
        RetrofitUrlManager.getInstance().with(builder).build();

    }
}
