package com.gingersoft.gsa.cloud.common.constans;

import com.gingersoft.gsa.cloud.common.BuildConfig;
import com.gingersoft.gsa.cloud.common.utils.other.SPUtils;

/**
 * Created by Wyh on 2019/12/21.
 */
public class HttpsConstans {

    //--------------------------------------------其他全局----------------------------------------------------------------------------
    /**
     * 正式服務器
     */
    private static String HTTP_ADDRESS_URL_FORMAL = "https://m.ricepon.com:8444";
    /**
     * 深圳測試
     */
    private static String HTTP_ADDRESS_URL_SZ = "http://gingersoft.tpddns.cn:58201";
    /**
     * 香港測試 https://hktest.ricepon.com
     */
    public static String HTTP_ADDRESS_URL_HK = "http://a.ricepon.com:58201";
    /**
     * 預發佈
     */
    private static String HTTP_ADDRESS_URL_PRE = "http://prf-m.ricepon.com";

    public static String CLOUD_GSA_API_PATH = "/ricepon-cloud-gsa/api/";//雲端GSA路徑
    public static String RESTAURANT_API_PATH = "/ricepon-restaurant/api/";//餐廳模塊路徑
    public static String PURCHASE_API_PATH = "/ricepon-purchase/api/";//供應鏈路徑

    //    public static String ROOT_SERVER_YOU_CHANG_HK = "http://192.168.1.149:9015/api"; //友常本地
    public static String ROOT_SERVER_YOU_CHANG_HK = "http://192.168.1.161:9016/api"; //溫浩本地
    public static String ROOT_SERVER_ZHI_WANG_HK = "http://192.168.1.169:9012/api"; //志旺本地
    public static String ROOT_SERVER_SHI_SHU_HK = "http://192.168.1.154:9012/api"; //石书本地

    //------------------------------------------外賣接單---------------------------------------------------------------------------
    public static final String URL_RICEPON_WECHAT = "/ricepon-wechat/api/";
    public static final String URL_RICEPON_ORDER = "/ricepon-order/api/";
    public static final String URK_RICEPON_GSA = "/ricepon-gsa/api/";
    public static final String URK_RICEPON_ACTIVITIES = "/ricepon-activities/api/";


    public static final String URL_MEMBER_WEB_RICEPON_GSA = "/member-web" + URK_RICEPON_GSA;

    public static final String ROOT_SZ_URL = "http://192.168.1.74:6060";//友常本地
    public static final String ROOT_HK_TEST_URL = "https://hktest.ricepon.com:64377";//香港測試
    public static final String ROOT_FORMAL_URL = "https://m.ricepon.com";//正式

    //-------------------------------------------報表-------------------------------------------------------------------------------
    public static String REPORT_TEST_ADDRESS = "http://a.ricepon.com:58201";//報表測試地址

    public static String REPORT_FORMAL_ADDRESS = HTTP_ADDRESS_URL_FORMAL;//報表正式地址
    //報表路徑
    public static String REPORT_PATH = "/ricepon-report/api/";

    //----------------------------------微信公眾號報表地址------------------------------------------------------------------------------------------
    public static String WECHAR_REPORT_TEST_ADDRESS = "http://a.ricepon.com:61177";//微信公眾號報表測試地址
    public static String WECHAR_REPORT_FORMAL_ADDRESS = HTTP_ADDRESS_URL_FORMAL;//微信公眾號報表正式地址
    public static String WECHAR_REPORT_PATH = "/member-web/api/";//微信公眾號報表路徑

    //---------------------------------------System請求地址----------------------------------------------------------------------------------
    public static String SYSTEM_PATH = "/ricepon-system/api/";
    public static String API_RICEPON_MEMBER = "/ricepon-member/api/";

    //-------------------------------------------支付-------------------------------------------------------------------------------
    public static String PAY_PATH = "/ricepon-pay/api/";

    /**
     * QRCode相關
     */
    public static final String PRINT_QRCODE_ADDRESS_URL_FORMAL = "http://m.ricepon.com";
    public static final String PRINT_QRCODE_ADDRESS_URL_HK = "http://hktest.ricepon.com:61177";

    //---------------------------------------打印Skyorder QRCode----------------------------------------------------------------------------------
    public static final String PRINT_SKY_QRCODE_SUFFIX = "/member-web/qrcode/qrcode.html?WMP0&?arg=";
    public static String PRINT_SKY_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_FORMAL + PRINT_SKY_QRCODE_SUFFIX;

    //----------------------------------------打印積分QRCode-----------------------------------------------------------------------------------------
    public static final String PRINT_QRCODE_SUFFIX = "/member-web/qrcode/qrcode.html?arg=";
    public static String PRINT_QRCODE_ADDRESS = PRINT_QRCODE_ADDRESS_URL_FORMAL + PRINT_QRCODE_SUFFIX;


    //--------------------------------------配置-----------------------------------------------------------------------------------
    /**
     * 修改這個值控制是否是正式
     * 0=正式
     * 1=香港
     * 2=預發佈
     * 3=友常
     * 4=石书
     */
    public static int isFormal = 0;
    public final static int FORMAL = 0;
    public final static int HK_SERVER = 1;
    public final static int PRE_SERVER = 2;
    public final static int YC_SERVER = 3;
    public final static int SS_SERVER = 4;
    /**
     * 沽清控制地址
     */
    public static String _SERVER_ADDRESS;
    /**
     * 清機接口地址
     */
    public static String ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL;

    public static String ROOT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_FORMAL + CLOUD_GSA_API_PATH;

    public static String ROOT_SERVER_ADDRESS_FORMAL_RESTAURANT = HTTP_ADDRESS_URL_FORMAL + RESTAURANT_API_PATH;

    public static String ROOT_SERVER_ADDRESS_RICEPON_PURCHASE = HTTP_ADDRESS_URL_FORMAL + PURCHASE_API_PATH;

    public static String ROOT_SERVER = HTTP_ADDRESS_URL_FORMAL;

    /**
     * 修改這個值，配置外賣接單環境
     */
    public static String ROOT_URL;

    /**
     * 修改這個值，修改報表默認環境
     */
    public static String REPORT_SERVER_ADDRESS;

    /**
     * 修改這個值，修改微信公眾號報表地址：首頁曲線圖數據，支付分析報表數據
     */
    public static String WECHAR_REPORT_SERVER_ADDRESS;

    public static String SYSTEM_URL;

    public static String RICEPON_MEMBER_61177;

    public static final String UPLOAD_PIC_ADDRESS = "/ricepon-member/api/admin/member/fileUploadBase64";

    public static String UPLOAD_PIC_URL;

    public static String HK_TEST_RICEPON_MEMBER;

    public static int getIsFormal() {
        isFormal = (int) SPUtils.get("isFormal", -1);
        return isFormal;
    }

    public static void init() {
        getIsFormal();
        if (isFormal == -1 && BuildConfig.DEBUG) {
            //如果沒有手動配置過服務器，並且是DEBUG模式，默認是測試服務器
            isFormal = 1;
        } else if (isFormal == -1) {
            isFormal = 0;
        }
        switch (isFormal) {
            default:
                initServerAddress(HTTP_ADDRESS_URL_FORMAL, HTTP_ADDRESS_URL_FORMAL, HTTP_ADDRESS_URL_FORMAL, HTTP_ADDRESS_URL_FORMAL, HTTP_ADDRESS_URL_FORMAL, ROOT_FORMAL_URL, REPORT_FORMAL_ADDRESS, WECHAR_REPORT_FORMAL_ADDRESS, HTTP_ADDRESS_URL_FORMAL, PRINT_QRCODE_ADDRESS_URL_FORMAL, HTTP_ADDRESS_URL_FORMAL);
                break;
            case HK_SERVER:
                initServerAddress(WECHAR_REPORT_TEST_ADDRESS, WECHAR_REPORT_TEST_ADDRESS, REPORT_TEST_ADDRESS, HTTP_ADDRESS_URL_HK, HTTP_ADDRESS_URL_HK, ROOT_HK_TEST_URL, REPORT_TEST_ADDRESS, WECHAR_REPORT_TEST_ADDRESS, ROOT_HK_TEST_URL, PRINT_QRCODE_ADDRESS_URL_HK, ROOT_HK_TEST_URL);
                break;
            case PRE_SERVER:
                initServerAddress(HTTP_ADDRESS_URL_PRE, HTTP_ADDRESS_URL_PRE, HTTP_ADDRESS_URL_PRE, HTTP_ADDRESS_URL_PRE, HTTP_ADDRESS_URL_PRE, HTTP_ADDRESS_URL_PRE, HTTP_ADDRESS_URL_PRE, HTTP_ADDRESS_URL_PRE, HTTP_ADDRESS_URL_PRE, PRINT_QRCODE_ADDRESS_URL_FORMAL, ROOT_HK_TEST_URL);
                break;
            case YC_SERVER:
                initServerAddress(WECHAR_REPORT_TEST_ADDRESS, ROOT_SERVER_ZHI_WANG_HK, REPORT_TEST_ADDRESS, ROOT_SERVER_ZHI_WANG_HK, ROOT_SERVER_YOU_CHANG_HK, ROOT_SZ_URL, REPORT_TEST_ADDRESS, WECHAR_REPORT_TEST_ADDRESS, ROOT_SERVER_ZHI_WANG_HK, PRINT_QRCODE_ADDRESS_URL_HK, ROOT_SERVER_YOU_CHANG_HK);
                break;
            case SS_SERVER:
                initServerAddress(WECHAR_REPORT_TEST_ADDRESS, ROOT_SERVER_YOU_CHANG_HK, REPORT_TEST_ADDRESS, ROOT_SERVER_YOU_CHANG_HK, ROOT_SERVER_YOU_CHANG_HK, ROOT_SZ_URL, REPORT_TEST_ADDRESS, WECHAR_REPORT_TEST_ADDRESS, ROOT_SERVER_YOU_CHANG_HK, ROOT_SERVER_YOU_CHANG_HK, ROOT_SERVER_YOU_CHANG_HK);
                break;
            case 5:
                initServerAddress(WECHAR_REPORT_TEST_ADDRESS, ROOT_SERVER_SHI_SHU_HK, REPORT_TEST_ADDRESS, ROOT_SERVER_SHI_SHU_HK, ROOT_SERVER_YOU_CHANG_HK, ROOT_SZ_URL, REPORT_TEST_ADDRESS, WECHAR_REPORT_TEST_ADDRESS, ROOT_SERVER_SHI_SHU_HK, PRINT_QRCODE_ADDRESS_URL_HK, ROOT_SERVER_YOU_CHANG_HK);
                break;
        }
        ricepon_pay = HttpsConstans.ROOT_URL + HttpsConstans.PAY_PATH;
        ricepon_wechat = HttpsConstans.ROOT_URL + HttpsConstans.URL_RICEPON_WECHAT;
        ricepon_order = HttpsConstans.ROOT_URL + HttpsConstans.URL_RICEPON_ORDER;
        member_web_ricepon_gsa = HttpsConstans.ROOT_URL + HttpsConstans.URL_MEMBER_WEB_RICEPON_GSA;
        member_web = HttpsConstans.ROOT_URL + HttpsConstans.WECHAR_REPORT_PATH;
        ricepon_gsa = HttpsConstans.ROOT_URL + HttpsConstans.URK_RICEPON_GSA;
        ricepon_activities = HttpsConstans.ROOT_URL + HttpsConstans.URK_RICEPON_ACTIVITIES;
        ricepon_cloud_gsa = HttpsConstans.ROOT_URL + HttpsConstans.CLOUD_GSA_API_PATH;
        ricepon_member = HttpsConstans.ROOT_URL + API_RICEPON_MEMBER;
    }

    private static void initServerAddress(String wecharReportTestAddress, String rootServerShiShuHk, String reportTestAddress, String rootServerShiShuHk2, String rootServerYouChangHk, String rootSzUrl, String reportTestAddress2, String wecharReportTestAddress2, String rootServerShiShuHk3, String printQrcodeAddressUrlHk, String rootServerYouChangHk2) {
        RICEPON_MEMBER_61177 = wecharReportTestAddress + API_RICEPON_MEMBER;
        _SERVER_ADDRESS = rootServerShiShuHk + WECHAR_REPORT_PATH;
        ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = reportTestAddress + REPORT_PATH;
        ROOT_SERVER_ADDRESS_FORMAL = rootServerShiShuHk2 + CLOUD_GSA_API_PATH;
        ROOT_SERVER_ADDRESS_FORMAL_RESTAURANT = rootServerYouChangHk + RESTAURANT_API_PATH;
        ROOT_SERVER_ADDRESS_RICEPON_PURCHASE = rootServerYouChangHk + PURCHASE_API_PATH;
        ROOT_URL = rootSzUrl;
        REPORT_SERVER_ADDRESS = reportTestAddress2 + REPORT_PATH;
        WECHAR_REPORT_SERVER_ADDRESS = wecharReportTestAddress2 + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
        SYSTEM_URL = rootServerShiShuHk3 + SYSTEM_PATH;
        ROOT_SERVER = rootServerYouChangHk;
        PRINT_QRCODE_ADDRESS = printQrcodeAddressUrlHk + PRINT_QRCODE_SUFFIX;
        UPLOAD_PIC_URL = rootServerYouChangHk2 + UPLOAD_PIC_ADDRESS;
        HK_TEST_RICEPON_MEMBER = rootServerYouChangHk2 + API_RICEPON_MEMBER;
    }

    public static String ricepon_pay;
    public static String ricepon_wechat;
    public static String ricepon_order;
    public static String member_web_ricepon_gsa;
    public static String member_web;
    public static String ricepon_gsa;
    public static String ricepon_activities;
    public static String ricepon_cloud_gsa;
    public static String ricepon_member;


}