package com.gingersoft.gsa.cloud.common.loadsir.pos;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.common.R;
import com.kingja.loadsir.callback.Callback;

public abstract class BasePosCallback extends Callback {

    private TextView tv_order_num;
    private TextView tv_final_prompt;
    private TextView tv_exception;
    private TextView tv_amount;
    private TextView tv_pay_method;

    public BasePosCallback() {
    }

    @Override
    protected void onViewCreate(Context context, View rootView) {
        tv_order_num = rootView.findViewById(R.id.tv_order_num);
        tv_final_prompt = rootView.findViewById(R.id.tv_final_prompt);
        tv_exception = rootView.findViewById(R.id.tv_exception);
        tv_amount = rootView.findViewById(R.id.tv_amount);
        tv_pay_method = rootView.findViewById(R.id.tv_pay_method);
    }

    public void setTvOrderNum(String orderNum) {
        tv_order_num.setText(orderNum);
    }

    public void setTvException(String orderNum) {
        tv_exception.setText(orderNum);
    }

    public void setTvAmount(String amount) {
        tv_amount.setText(amount);
    }

    public void setTvPayMethod(String payMethod) {
        tv_pay_method.setText(payMethod);
    }

    /**
     * 顯示重試多次還是無法查詢到狀態 顯示提示信息
     *
     * @param show
     */
    public void showFinalStrategy(boolean show) {
        if (show) {
            tv_final_prompt.setVisibility(View.VISIBLE);
        } else {
            tv_final_prompt.setVisibility(View.INVISIBLE);
        }
    }


}
