package com.gingersoft.gsa.cloud.common.service;

import android.content.Context;
import android.content.Intent;
import android.os.Build;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.common.utils.StytemUtils;
import com.gingersoft.gsa.cloud.component.ComponentName;

/**
 * @作者: bin
 * @創建時間: 2021-03-31 10:21
 * @更新時間: 2021-03-31 10:21
 * @描述:
 */
public class IServiceManager {

    public static final String TAG = IServiceManager.class.getSimpleName();

    public static void startICommandService(Context context) {
        boolean deliveryOrderServiceRunning = StytemUtils.isServiceRunning("com.gingersoft.gsa.cloud.common.service.ICommandService", context);
        if (!deliveryOrderServiceRunning) {
            Intent service = new Intent(GsaCloudApplication.getAppContext(), ICommandService.class);
            service.putExtra(ICommandService.CONNECTION_TYPE, ICommandService.mCurrConnectionType);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                context.startForegroundService(service);
            } else {
                context.startService(service);
            }
            LoganManager.w_tableMode(TAG, "启动->ICommandService");
        }
    }

    public static void startPrjService(Context context) {
        boolean prjServiceRunning = StytemUtils.isServiceRunning("com.joe.print.mvp.print.service.PrjService", context);
        if (!prjServiceRunning) {
            //開啟Prj打印服務
            CC.obtainBuilder(ComponentName.COMPONENT_PRINT)
                    .setActionName("openPrintService")
                    .build()
                    .call();
            LoganManager.w_tableMode(TAG, "启动->PrjService");
        }
    }

}
