package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;
import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.ColorBean;
import com.gingersoft.gsa.cloud.database.greendao.ColorBeanDao;

import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class ColorDaoUtils {

    private static final String TAG = ColorDaoUtils.class.getSimpleName();
    private DaoManager mManager;
    private Context mContext;

    public ColorDaoUtils(Context context) {
        mManager = DaoManager.getInstance();
        mManager.init(context);
        this.mContext = context;
    }

    /**
     * 清除緩存
     */
    public void detachAll() {
        ColorBeanDao colorBeanDao = DaoManager.getInstance().getDaoSession().getColorBeanDao();
        colorBeanDao.detachAll();
    }


    /**
     * 完成Food记录的插入，如果表未创建，先创建Food表
     *
     * @param colorBean
     * @return
     */
    public boolean insertColorBean(ColorBean colorBean) {
        boolean flag = false;
        flag = mManager.getDaoSession().getColorBeanDao().insert(colorBean) == -1 ? false : true;
        Log.i(TAG, "insert ColorBeanItem :" + flag + "-->" + colorBean.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     *
     * @param colorBeanList
     * @return
     */
    public boolean insertMultColorBean(final List<ColorBean> colorBeanList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (ColorBean colorBean : colorBeanList) {
                        mManager.getDaoSession().insertOrReplace(colorBean);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     *
     * @param colorBean
     * @return
     */
    public boolean updateColorBean(ColorBean colorBean) {
        boolean flag = false;
        try {
            mManager.getDaoSession().update(colorBean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     *
     * @param colorBean
     * @return
     */
    public boolean deleteColorBean(ColorBean colorBean) {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(colorBean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     *
     * @return
     */
    public boolean deleteAll() {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(ColorBean.class);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     *
     * @return
     */
    public List<ColorBean> queryAllColorBean() {
        return mManager.getDaoSession().loadAll(ColorBean.class);
    }

    /**
     * 根据主键id查询记录
     *
     * @param key
     * @return
     */
    public ColorBean queryColorBeanById(long key) {
        return mManager.getDaoSession().load(ColorBean.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<ColorBean> queryColorBeanByNativeSql(String sql, String[] conditions) {
        return mManager.getDaoSession().queryRaw(ColorBean.class, sql, conditions);
    }

}
