package com.gingersoft.gsa.cloud.database.utils;//package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.PrintModelBean;
import com.gingersoft.gsa.cloud.database.greendao.PrintModelBeanDao;

import org.greenrobot.greendao.query.QueryBuilder;

import java.util.List;

/**
 * Created by Wyh on 2020/1/17.
 */
public class PrintModelDaoUtil {

    private static final String TAG = PrintModelDaoUtil.class.getSimpleName();
    private DaoManager mManager;

    public PrintModelDaoUtil(Context context) {
        mManager = DaoManager.getInstance();
        mManager.init(context);
    }


    /**
     * 完成PrintModelBeanDao记录的插入，如果表未创建，先创建PrintModelBeanDao表
     * @return
     */
    public boolean insertPrintModelBeanDao(PrintModelBean printerDevice){
        boolean flag = false;
        flag = mManager.getDaoSession().getPrintModelBeanDao().insert(printerDevice) != -1;
        Log.i(TAG, "insert printerDevice :" + flag + "-->" + printerDevice.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     * @param printerDeviceList
     * @return
     */
    public boolean insertMultPrintModelBeanDao(final List<PrintModelBeanDao> printerDeviceList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (PrintModelBeanDao PrintModelBeanDao : printerDeviceList) {
                        mManager.getDaoSession().insertOrReplace(PrintModelBeanDao);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     * @param printerDevice
     * @return
     */
    public boolean updatePrintModelBeanDao(PrintModelBeanDao printerDevice){
        boolean flag = false;
        try {
            mManager.getDaoSession().update(printerDevice);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     * @param printerDevice
     * @return
     */
    public boolean deletePrintModelBeanDao(PrintModelBeanDao printerDevice){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(printerDevice);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     * @return
     */
    public boolean deleteAll(){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(PrintModelBeanDao.class);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     * @return
     */
    public List<PrintModelBeanDao> queryAllPrintModelBeanDao(){
        return mManager.getDaoSession().loadAll(PrintModelBeanDao.class);
    }

    /**
     * 根据主键id查询记录
     * @param key
     * @return
     */
    public PrintModelBeanDao queryPrintModelBeanDaoById(long key){
        return mManager.getDaoSession().load(PrintModelBeanDao.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<PrintModelBeanDao> queryPrintModelBeanDaoByNativeSql(String sql, String[] conditions){
        return mManager.getDaoSession().queryRaw(PrintModelBeanDao.class, sql, conditions);
    }

    /**
     * 使用queryBuilder进行查询
     * @return
     */
    public List<PrintModelBeanDao> queryPrintModelBeanDaoByQueryBuilder(long PrintModelBeanDaoId){
        QueryBuilder<PrintModelBeanDao> queryBuilder = mManager.getDaoSession().queryBuilder(PrintModelBeanDao.class);
        return queryBuilder.where(PrintModelBeanDao.Properties.Id.eq(PrintModelBeanDaoId)).list();
    }


}
