package com.gingersoft.gsa.cloud.order.discount;

import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.order.bean.discount.CouponDiscountBean;
import com.gingersoft.gsa.cloud.order.bean.discount.MemberWalletCoupon;

import lombok.Getter;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-19
 * 修订历史：2020-09-19
 * 描述: 會員錢包優惠券折扣{@link CouponDiscountBean}
 */
@Getter
public class MemberWalletCouponDiscount extends MultyDiscount {

    private MemberWalletCoupon walletCoupon;

    public MemberWalletCouponDiscount(String name, int status, MultyDiscount nextMultyDiscount, MemberWalletCoupon walletCoupon) {
        super(name, status, nextMultyDiscount);
        this.walletCoupon = walletCoupon;
    }

    @Override
    public double calculate(double money) {
        if (walletCoupon != null) {
            //配置了消費滿減
            discountMoney = calculationCoupon(walletCoupon, money);
            money = MoneyUtil.sum(money, discountMoney);
        }
        return super.calculate(money);
    }

    /**
     * 計算優惠券金額
     *
     * @param walletCoupon
     * @param sourceMoney
     * @return
     */
    public static double calculationCoupon(MemberWalletCoupon walletCoupon, double sourceMoney) {
        double discountMoney = 0;
        if (walletCoupon.getDiscount() != 0) {
            //百分比折扣
            discountMoney = MoneyUtil.divide(MoneyUtil.multiply(sourceMoney, walletCoupon.getDiscount()), 100).doubleValue();
        } else {
            //金額折扣
            discountMoney = walletCoupon.getAmount();
        }
        if (sourceMoney < discountMoney) {
            //折扣金額不能超出總額
            discountMoney = sourceMoney;
        }
        return -MoneyUtil.get_ItemDecimals_money(Math.abs(discountMoney));
    }

    /**
     * 獲取優惠券ID
     *
     * @return
     */
    public Long getCouponId() {
        if (walletCoupon != null) {
            return walletCoupon.getCouponId();
        }
        return null;
    }

}
