package com.gingersoft.gsa.cloud.pay;

import lombok.Getter;

/**
 * @作者: bin
 * @創建時間: 2021-04-16 10:17
 * @更新時間: 2021-04-16 10:17
 * @描述:
 */
@Getter
public enum PayStep {

    /**
     * 未支付
     * 支付中
     */
    LOADING("調起中..."),

    /**
     * 獲取事項ID失敗
     */
    FAILURE_OBTAIN_ID("調起失敗"),

    /**
     * 支付成功
     */
    SUCCESS("支付成功"),

    /**
     * 支付失败
     */
    FAILURE("支付失敗"),

    /**
     * 已支付未到账
     */
    NOT_ARRIVED("已支付未到賬"),

    /**
     * 已退款
     */
    REFUNDED("已退款"),

    /**
     * 廢棄(第二次結賬)
     */
    REPEAL("廢棄(第二次結賬)");

    private String stepName;

    PayStep(String stepName) {
        this.stepName = stepName;
    }
}
