package com.gingersoft.gsa.cloud.pay.device.pos.hyweb;


import com.gingersoft.gsa.cloud.pay.CommandCallback;
import com.gingersoft.gsa.cloud.pay.device.pos.base.bean.BasePosResponse;

/**
 * @作者: bin
 * @創建時間: 2020-12-29 20:15
 * @更新時間: 2020-12-29 20:15
 * @描述:POS事件回調
 */
public interface PosCallbackListener<T extends BasePosResponse> extends CommandCallback<BasePosResponse> {

    /**
     * 回調成功
     * @param response
     */
     void onPosSuccess(T response);

    /**
     * 回調狀態異常，需要去重試查詢
     * @param response
     * @param e
     */
    void onPosException(T response,Exception e);

    /**
     * 調起失敗
     * @param e
     */
    void onPosInvalid(String e);

    /**
     * 更新狀態成功
     * @param response
     */
     void onUpdateStatusSuccess(T response);

    /**
     * 更新狀態失敗
     * @param e
     */
    void onUpdateStatusError(Throwable e);




}
