package com.gingersoft.gsa.cloud.pay.device.pos.yedpay;

import android.util.SparseArray;

import androidx.fragment.app.FragmentManager;

import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.device.pos.PosCommand;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.constant.YedpayConstant;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.fragment.YedpayFragment;

/**
 * @作者: bin
 * @創建時間: 2021-04-14 12:08
 * @更新時間: 2021-04-14 12:08
 * @描述:
 */
public class YedpayCommandImp implements PosCommand<RequestParms> {

    private static YedpayCommandImp sYedpayCommand;
    private final SparseArray<String> mYedpayTypeMap = new SparseArray<>();

    public static YedpayCommandImp newInstance() {
        if (sYedpayCommand == null) {
            sYedpayCommand = new YedpayCommandImp();
        }
        return sYedpayCommand;
    }

    private YedpayCommandImp() {
        initPayTypeMap();
    }

    private void initPayTypeMap() {
        mYedpayTypeMap.put(1106, YedpayConstant.Method.ALIPAy);
        mYedpayTypeMap.put(1107, YedpayConstant.Method.wechatpay);
    }

    private String getPayType(int type) {
        if (mYedpayTypeMap.indexOfKey(type) != -1) {
            return mYedpayTypeMap.get(type);
        }
        return null;
    }

    @Override
    public void showActionDialog(FragmentManager fragmentManager, RequestParms requestParms) {
        YedpayFragment yedpayFragment = YedpayFragment.newInstance(requestParms);
        yedpayFragment.show(fragmentManager, yedpayFragment.getClass().getSimpleName());
    }

    @Override
    public void void0(RequestParms params) {

    }

    @Override
    public void tip(RequestParms params) {

    }

    @Override
    public void retrieval(RequestParms params) {
        String uriString = "yedpayapp://transaction_detail?c=" + params.getTxnId();
        YedpayCommand callback = (YedpayCommand) params.getCommandCallback();
        callback.retrieval(uriString);
    }

    @Override
    public void printStub(RequestParms params) {

    }

    @Override
    public void settlement(RequestParms params) {

    }

    @Override
    public void pay(RequestParms params) {
        //String uriString = "yedpayapp://transaction?g={{ 支付方式 }}&a={{ 銀碼 }}(&c={{ 自定義編號 }})";
        String uriString = "yedpayapp://transaction?g=" + getPayType(params.getPayType()) + "&a=" + params.getPayMoney() + "&c=" + params.getTxnId();
        YedpayCommand callback = (YedpayCommand) params.getCommandCallback();
        callback.callSaleUri(uriString);
    }

    @Override
    public void refund(RequestParms params) {
        YedpayCommand callback = (YedpayCommand) params.getCommandCallback();
        callback.refundResult(true);
    }


}
