package com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.contract;

import android.content.Intent;

import androidx.fragment.app.Fragment;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.pay.PayStep;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;

import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/30/2021 16:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface YedpayContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {

        void showStatusLoadingDialog(PayStep status);

        void startActivityForResult2(Intent intent,int requestCode);

        Fragment getFragment();
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {

        Single<BaseResult> getYedPayTxnId(RequestBody body);

        Single<BaseResult> getYedPayRefundTxnId(RequestBody body);

        Single<BaseResult> findSaleStatus(RequestBody body);

        Single<BaseResult> refundOrder(RequestBody body);

    }
}
