package com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.rxjava.MyRxSchedulerUtils;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.model.service.YedpayService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.contract.YedpayContract;

import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/30/2021 16:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class YedpayModel extends BaseModel implements YedpayContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public YedpayModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Single<BaseResult> getYedPayTxnId(RequestBody body) {
        return mRepositoryManager.obtainRetrofitService(YedpayService.class)
                .getYedPayTxnId(body)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> getYedPayRefundTxnId(RequestBody body) {
        return mRepositoryManager.obtainRetrofitService(YedpayService.class)
                .getYedPayRefundTxnId(body)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> findSaleStatus(RequestBody body) {
        return mRepositoryManager.obtainRetrofitService(YedpayService.class)
                .findSaleStatus(body)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> refundOrder(RequestBody body) {
        return mRepositoryManager.obtainRetrofitService(YedpayService.class)
                .refundOrder(body)
                .compose(MyRxSchedulerUtils._io_main_f());
    }
}