package com.gingersoft.gsa.cloud.print.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;

import java.util.List;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-12-03
 * @update date: 2020-12-03
 * @description:堂食結賬打印內容
 */
@Data
public class PrintBillContent implements PrintContent , Parcelable {

    private String brand;
    private String resturantName;
    private String tableName;
    private String orderNo;
    private int person;
    private String createTime;
    private List<PrintFoodItem> foodItemList;
    private List<PrintBillItem> billItemList;
    private List<PrintBillItem> payMethodItemList;
    private double wholeAmount;
    private double totalAmount;
    //會員相關
    private String memberName;
    private String phone;
    private double addPoints;
    private double oldPoints;
    private double nowPoints;
    //積分二維碼
    private String integralHead = "請掃描二維碼";
    private String integralQrCode;
    private String integralFoot = "《追加積分到個人賬戶》";
    //禮貌用語
    private String politeLanguage;

    public PrintBillContent() {
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.brand);
        dest.writeString(this.resturantName);
        dest.writeString(this.tableName);
        dest.writeString(this.orderNo);
        dest.writeInt(this.person);
        dest.writeString(this.createTime);
        dest.writeTypedList(this.foodItemList);
        dest.writeTypedList(this.billItemList);
        dest.writeTypedList(this.payMethodItemList);
        dest.writeDouble(this.wholeAmount);
        dest.writeDouble(this.totalAmount);
        dest.writeString(this.memberName);
        dest.writeString(this.phone);
        dest.writeDouble(this.addPoints);
        dest.writeDouble(this.oldPoints);
        dest.writeDouble(this.nowPoints);
        dest.writeString(this.integralHead);
        dest.writeString(this.integralQrCode);
        dest.writeString(this.integralFoot);
        dest.writeString(this.politeLanguage);
    }

    protected PrintBillContent(Parcel in) {
        this.brand = in.readString();
        this.resturantName = in.readString();
        this.tableName = in.readString();
        this.orderNo = in.readString();
        this.person = in.readInt();
        this.createTime = in.readString();
        this.foodItemList = in.createTypedArrayList(PrintFoodItem.CREATOR);
        this.billItemList = in.createTypedArrayList(PrintBillItem.CREATOR);
        this.payMethodItemList = in.createTypedArrayList(PrintBillItem.CREATOR);
        this.wholeAmount = in.readDouble();
        this.totalAmount = in.readDouble();
        this.memberName = in.readString();
        this.phone = in.readString();
        this.addPoints = in.readDouble();
        this.oldPoints = in.readDouble();
        this.nowPoints = in.readDouble();
        this.integralHead = in.readString();
        this.integralQrCode = in.readString();
        this.integralFoot = in.readString();
        this.politeLanguage = in.readString();
    }

    public static final Creator<PrintBillContent> CREATOR = new Creator<PrintBillContent>() {
        @Override
        public PrintBillContent createFromParcel(Parcel source) {
            return new PrintBillContent(source);
        }

        @Override
        public PrintBillContent[] newArray(int size) {
            return new PrintBillContent[size];
        }
    };
}
