package com.gingersoft.gsa.cloud.print.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;

import java.util.List;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-12-03
 * @update date: 2020-12-03
 * @description:堂食上菜紙打印內容
 */
@Data
public class PrintServingPaperContent implements  PrintContent ,Parcelable{

    private String brand;
    private String resturantName;
    private String tableName;
    private String orderNo;
    private int person;
    private String createTime;
    private List<PrintFoodItem> foodItemList;
    //禮貌用語
    private String politeLanguage;

    public PrintServingPaperContent() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.brand);
        dest.writeString(this.resturantName);
        dest.writeString(this.tableName);
        dest.writeString(this.orderNo);
        dest.writeInt(this.person);
        dest.writeString(this.createTime);
        dest.writeTypedList(this.foodItemList);
        dest.writeString(this.politeLanguage);
    }

    protected PrintServingPaperContent(Parcel in) {
        this.brand = in.readString();
        this.resturantName = in.readString();
        this.tableName = in.readString();
        this.orderNo = in.readString();
        this.person = in.readInt();
        this.createTime = in.readString();
        this.foodItemList = in.createTypedArrayList(PrintFoodItem.CREATOR);
        this.politeLanguage = in.readString();
    }

    public static final Creator<PrintServingPaperContent> CREATOR = new Creator<PrintServingPaperContent>() {
        @Override
        public PrintServingPaperContent createFromParcel(Parcel source) {
            return new PrintServingPaperContent(source);
        }

        @Override
        public PrintServingPaperContent[] newArray(int size) {
            return new PrintServingPaperContent[size];
        }
    };
}
