package com.gingersoft.gsa.cloud.print.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;

import java.util.List;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-12-03
 * @update date: 2020-12-03
 * @description:堂食印單打印內容
 * */
@Data
public class PrintSlipContent implements  PrintContent ,Parcelable{

    private String brand;
    private String resturantName;
    private String tableName;
    private String orderNo;
    private int person;
    private String createTime;
    private List<PrintFoodItem> foodItemList;
    private List<PrintBillItem> billItemList;
    private double wholeAmount;
    private double totalAmount;
    //禮貌用語
    private String politeLanguage;

    public PrintSlipContent() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.brand);
        dest.writeString(this.resturantName);
        dest.writeString(this.tableName);
        dest.writeString(this.orderNo);
        dest.writeInt(this.person);
        dest.writeString(this.createTime);
        dest.writeTypedList(this.foodItemList);
        dest.writeTypedList(this.billItemList);
        dest.writeDouble(this.wholeAmount);
        dest.writeDouble(this.totalAmount);
        dest.writeString(this.politeLanguage);
    }

    protected PrintSlipContent(Parcel in) {
        this.brand = in.readString();
        this.resturantName = in.readString();
        this.tableName = in.readString();
        this.orderNo = in.readString();
        this.person = in.readInt();
        this.createTime = in.readString();
        this.foodItemList = in.createTypedArrayList(PrintFoodItem.CREATOR);
        this.billItemList = in.createTypedArrayList(PrintBillItem.CREATOR);
        this.wholeAmount = in.readDouble();
        this.totalAmount = in.readDouble();
        this.politeLanguage = in.readString();
    }

    public static final Creator<PrintSlipContent> CREATOR = new Creator<PrintSlipContent>() {
        @Override
        public PrintSlipContent createFromParcel(Parcel source) {
            return new PrintSlipContent(source);
        }

        @Override
        public PrintSlipContent[] newArray(int size) {
            return new PrintSlipContent[size];
        }
    };
}
