package com.gingersoft.gsa.cloud.ui.adapter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

import com.qmuiteam.qmui.arch.QMUIFragmentPagerAdapter;

import java.util.List;

/**
 * @作者: bin
 * @創建時間: 2021-04-23 12:04
 * @更新時間: 2021-04-23 12:04
 * @描述:
 */
public class IQMUIFragmentPagerAdapter extends QMUIFragmentPagerAdapter {

    private List<Fragment> fragments;
    private List<String> tabTitles;

    public IQMUIFragmentPagerAdapter(@NonNull FragmentManager fm, @NonNull List<Fragment> fragments, @NonNull List<String> tabTitles) {
        super(fm);
        this.fragments = fragments;
        this.tabTitles = tabTitles;
    }

    @Override
    public Fragment createFragment(int position) {
        return fragments.get(position);
    }

    @Override
    public int getCount() {
        return fragments.size();
    }

    @Nullable
    @Override
    public CharSequence getPageTitle(int position) {
        return tabTitles.get(position);
    }
}
