package com.gingersoft.gsa.cloud.ui.adapter.base;


import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.viewpager2.adapter.FragmentStateAdapter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author admin
 */
public class BaseFragmentStateAdapter extends FragmentStateAdapter {

    List<Fragment> fragmentList;

    public BaseFragmentStateAdapter(@NonNull FragmentActivity fragmentActivity) {
        super(fragmentActivity);
        fragmentList = new ArrayList<>();
    }

    public BaseFragmentStateAdapter(@NonNull Fragment fragment) {
        super(fragment);
        fragmentList = new ArrayList<>();
    }

    public BaseFragmentStateAdapter(@NonNull FragmentManager fragmentManager, @NonNull Lifecycle lifecycle) {
        super(fragmentManager, lifecycle);
        fragmentList = new ArrayList<>();
    }

    public void addFragment(Fragment fragment) {
        fragmentList.add(fragment);
        notifyDataSetChanged();
    }
    public void addFragments(List<Fragment> fragments) {
        fragmentList.addAll(fragments);
        notifyDataSetChanged();
    }
    public void removeFragment() {
        if (fragmentList.size() > 0) {
            fragmentList.remove(fragmentList.size() - 1);
            notifyDataSetChanged();
        }
    }

    @NonNull
    @Override
    public Fragment createFragment(int position) {
        return fragmentList.get(position);
    }

    @Override
    public int getItemCount() {
        return fragmentList.size();
    }

}
