package com.gingersoft.gsa.cloud.ui.bean.view;

import com.qmuiteam.qmui.widget.section.QMUISection;

import java.util.Objects;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 11:45
 * Use: 共用的分類型左側分類數據
 */
@Data
public class CategoryBean implements QMUISection.Model<CategoryBean> {
    private Integer id;
    private String categoryName;
    /**
     * 數量
     */
    private int count;


    public CategoryBean() {
    }

    public CategoryBean(int id, String categoryName) {
        this.id = id;
        this.categoryName = categoryName;
    }

    public CategoryBean(int id, String categoryName, int count) {
        this.id = id;
        this.categoryName = categoryName;
        this.count = count;
    }

    @Override
    public CategoryBean cloneForDiff() {
        return new CategoryBean(getId(), getCategoryName(), getCount());
    }

    @Override
    public boolean isSameItem(CategoryBean other) {
        return Objects.equals(categoryName, other.getCategoryName());
    }

    @Override
    public boolean isSameContent(CategoryBean other) {
        return true;
    }
}
