package com.gingersoft.gsa.cloud.ui.utils;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.WindowManager;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.RadioListAdapter;
import com.jess.arms.utils.ArmsUtils;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.impl.InputConfirmPopupView;
import com.lxj.xpopup.interfaces.OnCancelListener;
import com.lxj.xpopup.interfaces.OnConfirmListener;

import java.util.List;

/**
 * app常用彈窗
 */
public class AppDialog {
    private static AppDialog appDialog;

    public static AppDialog getInstance() {
        if (appDialog == null) {
            appDialog = new AppDialog();
        }
        return appDialog;
    }


    public void showWaringDialog(Context context, String title, OnConfirmListener confirmListener) {
        showWaringDialog(context, title, null, null, confirmListener, null, true);
    }

    public void showWaringDialog(Context context, String title, OnConfirmListener confirmListener, OnCancelListener cancelListener) {
        showWaringDialog(context, title, null, null, confirmListener, cancelListener, true);
    }

    public void showWaringDialog(Context context, String title, boolean isDismiss, OnConfirmListener confirmListener, OnCancelListener cancelListener) {
        showWaringDialog(context, title, null, null, confirmListener, cancelListener, isDismiss);
    }

    private void showWaringDialog(Context context, String title, String sureBtnText, String cancelBtnText, OnConfirmListener confirmListener, OnCancelListener cancelListener, boolean isDismiss) {
        new XPopup.Builder(context).asConfirm(title, "", cancelBtnText, sureBtnText, confirmListener, cancelListener, false, R.layout.other_order_pause_orders).show();
    }

    public void showSelectDialog(Context context, String title, int spanCount, RecyclerView.Adapter adapter, DialogOnClickListener sureOnclickListenter) {
        new DialogUtils(context, R.layout.dialog_select_layout) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                hepler.setText(R.id.tv_title, title);
                hepler.setAdapter(R.id.rv_delivery, new GridLayoutManager(context, spanCount), adapter);
                hepler.setOnClickListenter(R.id.tv_delivery_confirm, v -> sureOnclickListenter.onclick(v, dialog));
                hepler.setOnClickListenter(R.id.tv_delivery_cancel, v -> sureOnclickListenter.onclick(v, dialog));
            }
        }
                .setWidth(WindowManager.LayoutParams.MATCH_PARENT)
                .setHeight((int) (ArmsUtils.getScreenHeidth(context) * 0.5))
                .setGravity(Gravity.BOTTOM)
                .show();
    }

    public void showSelectDialog(Context context, String title, List<String> list, int defaultCheck, onDialogSelectListener onDialogSelectListener) {
        RadioListAdapter radioListAdapter = new RadioListAdapter(list);
        radioListAdapter.setSelectIndex(defaultCheck);
        showSelectDialog(context, title, 1, radioListAdapter, (view, dialog) -> {
            if (onDialogSelectListener != null) {
                onDialogSelectListener.onclick(view, dialog, radioListAdapter.getSelectIndex());
            }
        });
    }

    /**
     * 藍色的提示框
     */
    public void showTipDialog(Context context, String title, OnConfirmListener sureOnclickListener) {
        showTipDialog(context, title, context.getString(R.string.str_determine), context.getString(R.string.str_cancel), sureOnclickListener, null);
    }

    /**
     * 藍色的提示框
     */
    public void showTipDialog(Context context, String title, OnConfirmListener sureOnclickListener, OnCancelListener onCancelListener) {
        showTipDialog(context, title, context.getString(R.string.str_determine), context.getString(R.string.str_cancel), sureOnclickListener, onCancelListener);
    }

    public void showTipDialog(Context context, String title, String sureBtnText, String cancelBtnText, OnConfirmListener sureOnclickListener, OnCancelListener onCancelListener) {
        new XPopup.Builder(context).asConfirm(title, "", cancelBtnText, sureBtnText, sureOnclickListener, onCancelListener, false, R.layout.dialog_tip).show();
    }

    public void showListDialog(Context context, String[] data, onDialogSelectListener onSelectListener) {
        new XPopup.Builder(context)
                .dismissOnTouchOutside(true)
                .asBottomList(null, data, (position, text) -> onSelectListener.onclick(null, null, position)).show();
    }


    public void showEditDialog(Context context, CharSequence title, CharSequence content, CharSequence inputContent, CharSequence hint, OnInputConfirmListener confirmListener) {
        showEditDialog(context, title, content, inputContent, hint, confirmListener, R.layout.dialog_edit);
    }

    public void showEditDialog(Context context, CharSequence title, CharSequence content, CharSequence inputContent, CharSequence hint, OnInputConfirmListener confirmListener, int layoutId) {
        showEditDialog(context, title, content, inputContent, hint, confirmListener, null, layoutId);
    }

    public void showEditDialog(Context context, CharSequence title, CharSequence content, CharSequence inputContent, CharSequence hint, OnInputConfirmListener confirmListener, OnCancelListener cancelListener, int layoutId) {
        InputConfirmPopupView inputConfirmPopupView = new XPopup.Builder(context)
                .asInputConfirm(title, content, inputContent, hint, text -> {
                    if (confirmListener != null) {
                        confirmListener.onConfirm(text);
                    }
                }, cancelListener, layoutId);
        inputConfirmPopupView.show();
    }


    public interface DialogOnClickListener {
        void onclick(View view, Dialog dialog);
    }

    public interface onDialogSelectListener {
        void onclick(View view, Dialog dialog, int position);
    }

    public interface OnInputConfirmListener {
        void onConfirm(String text);
    }

    public void showCustomPop(Context context, BasePopupView popupView) {
        new XPopup.Builder(context.getApplicationContext())
                .asCustom(popupView)
                .show();
    }


}
