package com.gingersoft.gsa.cloud.ui.utils;

import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.tab.QMUITabIndicator;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment2;

/**
 * @作者: bin
 * @創建時間: 2021-04-2 14:17
 * @更新時間: 2021-04-2 14:17
 * @描述:
 */
public class QMUITabSegmentUtils {

    public static void setNomalTabSegmentStyle(QMUITabSegment2 tabSegment, ViewPager2 viewPager){
        GsaCloudApplication appContext = GsaCloudApplication.getAppContext();
        int space = QMUIDisplayHelper.dp2px(appContext, 16);
        tabSegment.setIndicator(new QMUITabIndicator(QMUIDisplayHelper.dp2px(appContext, 2), false, true));
        tabSegment.setDefaultTextSize(space, space);
        tabSegment.setPadding(space, 0, space, 0);
        tabSegment.setupWithViewPager(viewPager);
    }

}
