package com.gingersoft.gsa.cloud.main.mvp.ui.fragment;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.gingersoft.gsa.cloud.common.webview.WebviewHelper;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerReportListComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.ReportListContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.ReportListItem;
import com.gingersoft.gsa.cloud.main.mvp.presenter.ReportListPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.ReportListAdapter;
import com.gyf.immersionbar.ImmersionBar;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/27/2021 12:07
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class ReportListFragment extends BaseFragment<ReportListPresenter> implements ReportListContract.View {

    @BindView(R2.id.topBar)
    QMUITopBar topBar;
    @BindView(R2.id.recycler_report)
    RecyclerView recyclerReport;

    private ReportListAdapter mReportListAdapter;

    public static ReportListFragment newInstance() {
        ReportListFragment fragment = new ReportListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerReportListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public void configImmersionBar(ImmersionBar immersionBar) {
        immersionBar
                .statusBarColor(R.color.red)
                .barColor(R.color.red)
                .init();
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_report_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        topBar.setBackgroundColor(ContextCompat.getColor(mContext, R.color.theme_color));
        topBar.addLeftBackImageButton().setVisibility(View.GONE);
        topBar.setTitle("报表");

        Drawable drawable = getResources().getDrawable(R.drawable.ic_line);
        drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());

        List<ReportListItem> reportListItems = new ArrayList<>(5);
        reportListItems.add(new ReportListItem(drawable,"食品销售排行","https://wyn.ricepon.com/reports/view/eea52d08-cad6-4afe-bb09-2e8349b81f5f?display=pageless&size=fitwidth&parampanel=top&dp=%7B%22userId%22%3A%5B%22340%22%5D%2C%22%E5%B7%B2%E6%9C%89%E5%93%81%E7%89%8C%22%3A%5B%22-1%22%5D%2C%22%E5%B7%B2%E6%9C%89%E9%A4%90%E5%BB%B3%22%3A%5B%22-1%22%5D%2C%22%E5%93%81%E7%89%8C%22%3A%5B%221%22%5D%2C%22%E9%A4%90%E5%BB%B3%22%3A%5B%2226%22%5D%2C%22%E6%8E%92%E5%BA%8F%E9%A1%9E%E5%9E%8B%22%3A%5B%221%22%5D%2C%22%E9%96%8B%E5%A7%8B%E6%97%A5%E6%9C%9F%22%3A%5B%222021-01-31T16%3A00%3A00.000Z%22%5D%2C%22%E7%B5%90%E6%9D%9F%E6%97%A5%E6%9C%9F%22%3A%5B%222021-03-23T16%3A00%3A00.000Z%22%5D%7D&theme=default&lng=zh-TW&token=5c80dba856cd9ef65b55aa487571d101ef11bdbd1256de11b862845a99ca8d01"));
        reportListItems.add(new ReportListItem(drawable,"营业报表","https://wyn.ricepon.com/reports/view/eea52d08-cad6-4afe-bb09-2e8349b81f5f?display=pageless&size=fitwidth&parampanel=top&dp=%7B%22userId%22%3A%5B%22340%22%5D%2C%22%E5%B7%B2%E6%9C%89%E5%93%81%E7%89%8C%22%3A%5B%22-1%22%5D%2C%22%E5%B7%B2%E6%9C%89%E9%A4%90%E5%BB%B3%22%3A%5B%22-1%22%5D%2C%22%E5%93%81%E7%89%8C%22%3A%5B%221%22%5D%2C%22%E9%A4%90%E5%BB%B3%22%3A%5B%2226%22%5D%2C%22%E6%8E%92%E5%BA%8F%E9%A1%9E%E5%9E%8B%22%3A%5B%221%22%5D%2C%22%E9%96%8B%E5%A7%8B%E6%97%A5%E6%9C%9F%22%3A%5B%222021-01-31T16%3A00%3A00.000Z%22%5D%2C%22%E7%B5%90%E6%9D%9F%E6%97%A5%E6%9C%9F%22%3A%5B%222021-03-23T16%3A00%3A00.000Z%22%5D%7D&theme=default&lng=zh-TW&token=5c80dba856cd9ef65b55aa487571d101ef11bdbd1256de11b862845a99ca8d01"));
        reportListItems.add(new ReportListItem(drawable,"订单报表","https://wyn.ricepon.com/reports/view/eea52d08-cad6-4afe-bb09-2e8349b81f5f?display=pageless&size=fitwidth&parampanel=top&dp=%7B%22userId%22%3A%5B%22340%22%5D%2C%22%E5%B7%B2%E6%9C%89%E5%93%81%E7%89%8C%22%3A%5B%22-1%22%5D%2C%22%E5%B7%B2%E6%9C%89%E9%A4%90%E5%BB%B3%22%3A%5B%22-1%22%5D%2C%22%E5%93%81%E7%89%8C%22%3A%5B%221%22%5D%2C%22%E9%A4%90%E5%BB%B3%22%3A%5B%2226%22%5D%2C%22%E6%8E%92%E5%BA%8F%E9%A1%9E%E5%9E%8B%22%3A%5B%221%22%5D%2C%22%E9%96%8B%E5%A7%8B%E6%97%A5%E6%9C%9F%22%3A%5B%222021-01-31T16%3A00%3A00.000Z%22%5D%2C%22%E7%B5%90%E6%9D%9F%E6%97%A5%E6%9C%9F%22%3A%5B%222021-03-23T16%3A00%3A00.000Z%22%5D%7D&theme=default&lng=zh-TW&token=5c80dba856cd9ef65b55aa487571d101ef11bdbd1256de11b862845a99ca8d01"));

        mReportListAdapter = new ReportListAdapter(reportListItems);
        recyclerReport.setAdapter(mReportListAdapter);
        mReportListAdapter.setOnItemClickListener(new OnItemClickListener() {
            @Override
            public void onItemClick(@NonNull BaseQuickAdapter<?, ?> adapter, @NonNull View view, int position) {
                WebviewHelper.openWebview(reportListItems.get(position).getReportUrl());
            }
        });
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        _mActivity.finish();
    }
}
