/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.epson.epsonio.DeviceInfo;
import com.epson.epsonio.EpsonIoException;
import com.epson.epsonio.bluetooth.AdapterHandler;
import java.util.ArrayList;
import java.util.Set;

public class DevBt {
    private static ArrayList<DeviceInfo> mDeviceInfoList = new ArrayList();
    private static BluetoothAdapter mAdapter = null;
    private static BroadcastReceiver mReceiver = null;
    private static Context mContext = null;
    private static boolean mIsFinding = false;
    private static final int MBT_DEV_SUB_CLASS_PRINTER = 128;
    private static final int MBT_DEV_SUB_CLASS_PRINTER_MASK = 128;
    private static Integer unregisterReceiverSynchronizer = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    private static final Handler unregisterReceiverCallbackHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                Integer n = unregisterReceiverSynchronizer;
                synchronized (n) {
                    mContext.unregisterReceiver(mReceiver);
                    unregisterReceiverSynchronizer.notify();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int start(Context caller, int deviceType, String deviceName, int bondedDevices) {
        Set pairedDevices;
        if (mIsFinding) {
            return 6;
        }
        if (258 != deviceType) {
            return 1;
        }
        if (null != deviceName) {
            return 1;
        }
        if (bondedDevices != 1 && bondedDevices != 0) {
            return 1;
        }
        if (null == caller) {
            return 1;
        }
        ArrayList<DeviceInfo> arrayList = mDeviceInfoList;
        synchronized (arrayList) {
            mDeviceInfoList.clear();
        }
        mContext = caller;
        if (null == mAdapter) {
            AdapterHandler mHandler = new AdapterHandler();
            if (mHandler.getLooper().getThread().getId() != Thread.currentThread().getId()) {
                try {
                    mAdapter = mHandler.getAdapter();
                }
                catch (EpsonIoException e) {
                    return e.getStatus();
                }
            } else {
                mAdapter = BluetoothAdapter.getDefaultAdapter();
            }
        }
        if (null == mAdapter) {
            return 255;
        }
        if (!mAdapter.isEnabled()) {
            return 6;
        }
        if (bondedDevices == 1 && (pairedDevices = mAdapter.getBondedDevices()) != null && pairedDevices.size() > 0) {
            for (BluetoothDevice device : pairedDevices) {
                DeviceInfo deviceInfo = new DeviceInfo(258, device.getName(), device.getAddress(), "", "");
                mDeviceInfoList.add(deviceInfo);
            }
        }
        mReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.device.action.FOUND".equals(action)) {
                    int majorClass;
                    BluetoothClass bluetoothClass;
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    if (null != device && null != (bluetoothClass = device.getBluetoothClass()) && (7936 == (majorClass = bluetoothClass.getMajorDeviceClass()) || 1536 == majorClass && 128 == (0x80 & bluetoothClass.getDeviceClass()))) {
                        ArrayList arrayList = mDeviceInfoList;
                        synchronized (arrayList) {
                            Boolean bFind = false;
                            for (DeviceInfo devInfo : mDeviceInfoList) {
                                String work = devInfo.getDeviceName();
                                if (!work.equalsIgnoreCase(device.getAddress())) continue;
                                bFind = true;
                                break;
                            }
                            if (!bFind.booleanValue()) {
                                DeviceInfo deviceInfo = new DeviceInfo(258, device.getName(), device.getAddress(), "", "");
                                mDeviceInfoList.add(deviceInfo);
                            }
                        }
                    }
                } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                    mAdapter.startDiscovery();
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        mContext.registerReceiver(mReceiver, filter);
        if (!mAdapter.startDiscovery()) {
            DevBt.stop();
            return 6;
        }
        mIsFinding = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DeviceInfo[] getResult(int[] errStatus, int filterOption) {
        DeviceInfo[] deviceInfoList = null;
        if (null == errStatus || 0 == errStatus.length) {
            return null;
        }
        errStatus[0] = 255;
        if (!mIsFinding) {
            errStatus[0] = 6;
            return null;
        }
        try {
            ArrayList<DeviceInfo> arrayList = mDeviceInfoList;
            synchronized (arrayList) {
                if (0 < mDeviceInfoList.size()) {
                    DeviceInfo devInfo = null;
                    ArrayList<DeviceInfo> tmpDevInfo = new ArrayList<DeviceInfo>();
                    for (int i = 0; i < mDeviceInfoList.size(); ++i) {
                        boolean setFlg = false;
                        devInfo = mDeviceInfoList.get(i);
                        switch (filterOption) {
                            case -2: 
                            case 1: {
                                if (!DevBt.deviceFilter(devInfo.getPrinterName())) break;
                                setFlg = true;
                                break;
                            }
                            default: {
                                setFlg = true;
                            }
                        }
                        if (!setFlg) continue;
                        DeviceInfo deviceInfo = new DeviceInfo(devInfo.getDeviceType(), devInfo.getPrinterName(), devInfo.getDeviceName(), "", "");
                        tmpDevInfo.add(deviceInfo);
                    }
                    deviceInfoList = tmpDevInfo.toArray(new DeviceInfo[tmpDevInfo.size()]);
                }
            }
            errStatus[0] = 0;
        }
        catch (Exception e) {
            errStatus[0] = 5;
        }
        return deviceInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int stop() {
        if (!mIsFinding) {
            return 6;
        }
        mIsFinding = false;
        if (null != mReceiver) {
            if (unregisterReceiverCallbackHandler.getLooper().getThread().getId() != Thread.currentThread().getId()) {
                Integer n = unregisterReceiverSynchronizer;
                synchronized (n) {
                    Message msg = unregisterReceiverCallbackHandler.obtainMessage(0);
                    unregisterReceiverCallbackHandler.sendMessage(msg);
                    try {
                        unregisterReceiverSynchronizer.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            mContext.unregisterReceiver(mReceiver);
        }
        if (null != mAdapter && mAdapter.isDiscovering()) {
            mAdapter.cancelDiscovery();
        }
        mReceiver = null;
        mAdapter = null;
        return 0;
    }

    private static boolean deviceFilter(String device) {
        boolean ret = false;
        try {
            if (device.startsWith("TM-T")) {
                ret = true;
            } else if (device.startsWith("TM-P")) {
                ret = true;
            } else if (device.startsWith("TM-m")) {
                ret = true;
            } else if (device.startsWith("UB-B")) {
                ret = true;
            } else if (device.matches("BT304")) {
                ret = true;
            } else if (device.startsWith("TM-H")) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }
}

