package com.gingersoft.gsa.cloud.common.core.discount;

import com.gingersoft.gsa.cloud.database.bean.Discount;

import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2021-04-07 15:45
 * @更新時間: 2021-04-07 15:45
 * @描述:
 */
@Data
public class MemberCoupon extends AbstractDiscount {

    private long id;
    private String couponTypeName;
    private String beginDate;
    private String endDate;
    private int periodDays;
    private int upperLimitTimes;
    private double billMinAmount;
    private double amount;
    private int discount;
    private String remark;
    private String couponNo;
    private int useTimes;


    public Discount castDiscount() {
        Discount discount = new Discount();
        discount.setId(getId());
        discount.setDiscountValue(getDiscount());
        discount.setMinBillAmount(getBillMinAmount());
        discount.setRemark(getRemark());
        discount.setBeginTime(getBeginDate());
        discount.setEndTime(getEndDate());
        return discount;
    }
}