package com.gingersoft.gsa.cloud.common.utils.gson;

import com.alibaba.fastjson.JSONException;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * autour: 宁斌
 * date: 2018/3/24 10:15
 * update: 2018/3/24 10:15
 * description:
 */

public class GsonUtils {

    private static Gson gson = null;

    static {
        if (gson == null) {
            gson = new Gson();
        }
    }

    private GsonUtils() {
    }

    /**
     * 转成json
     *
     * @param object
     * @return
     */
    public static String GsonString(Object object) {
        String gsonString = null;
        try {
            if (gson != null) {
                gsonString = gson.toJson(object);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return gsonString;
    }

    /**
     * 转成bean
     *
     * @param gsonString
     * @param cls
     * @return
     */
    public static <T> T GsonToBean(String gsonString, Class<T> cls) {
        T t = null;
        try {
            if (gson != null) {
                t = gson.fromJson(gsonString, cls);
            }
        } catch (JSONException | JsonSyntaxException | IllegalStateException e) {
            e.printStackTrace();
        }
        return t;
    }

    /**
     * 转成bean
     *
     * @param gsonString
     * @param cls
     * @return
     */
    public static <T> T GsonToBean(Object gsonString, Class<T> cls) {
//        JsonObject jsonObject = new JsonParser().parse(GsonString(gsonString)).getAsJsonObject();
//        return gson.fromJson(jsonObject, cls);
        return GsonToBean(GsonString(gsonString), cls);
    }

    /**
     * Object轉List
     * @param object
     * @param cls
     * @param <T>
     * @return
     */
//    public static <T> List GsonToList(Object object, Class<T> cls) {
//        List<T> mList = new ArrayList<>();
//        JsonArray array = new JsonParser().parse(GsonString(object)).getAsJsonArray();
//        for (final JsonElement elem : array) {
//            mList.add(gson.fromJson(elem, cls));
//        }
//        return mList;
//    }


    // 有問題，轉換出來的類型不對
//    /**
//     * 转成list
//     *
//     * @param gsonString
//     * @param cls
//     * @return
//     */
//    public static <T> List<T> GsonToList(String gsonString, Class<T> cls) {
//        List<T> list = null;
//        if (gson != null) {
//            list = gson.fromJson(gsonString, new TypeToken<List<T>>() {
//            }.getType());
//        }
//        return list;
//    }

    /**
     * json字符串转成list
     *
     * @param cls
     * @return
     */
    public static <T> List<T> jsonToList(Object object, Class<T> cls) {
        return jsonToList(GsonString(object), cls);
    }

    /**
     * json字符串转成list
     *
     * @param cls
     * @return
     */
    public static <T> List<T> jsonToList(String json, Class<T> cls) {
        ArrayList<T> mList = new ArrayList<>();
        if (TextUtil.isEmptyOrNullOrUndefined(json)) {
            return null;
        }
        JsonArray array = new JsonParser().parse(json).getAsJsonArray();
        for (final JsonElement elem : array) {
            mList.add(gson.fromJson(elem, cls));
        }
        return mList;
    }

    /**
     * 转成list中有map的
     *
     * @param gsonString
     * @return
     */
    public static <T> List<Map<String, T>> GsonToListMaps(String gsonString) {
        List<Map<String, T>> list = null;
        if (gson != null) {
            list = gson.fromJson(gsonString,
                    new TypeToken<List<Map<String, T>>>() {
                    }.getType());
        }
        return list;
    }

    /**
     * 转成map的
     *
     * @param gsonString
     * @return
     */
    public static <T> Map<String, T> GsonToMaps(String gsonString) {
        Map<String, T> map = null;
        if (gson != null) {
            map = gson.fromJson(gsonString, new TypeToken<Map<String, T>>() {
            }.getType());
        }
        return map;
    }
}
