package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.WarehouseDetailsBean;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.WarehouseDetailsFragment;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/22
 * Time: 14:45
 * Use:
 */
public class WareHousingDetailsAdapter extends BaseQuickAdapter<WarehouseDetailsBean, BaseViewHolder> {
    /**
     * 入庫還是出庫
     * 入庫顯示+，出庫顯示-
     */
    private int type;
    /**
     * 已消耗的背景色
     */
    private Drawable allConsumeBg;
    /**
     * 已過期的背景
     */
    private Drawable expiredBg;
    /**
     * 即將過期背景
     */
    private Drawable willExpireSoonBg;

    public WareHousingDetailsAdapter(Context context, @Nullable List<WarehouseDetailsBean> data, int type) {
        super(R.layout.item_warehouse_details, data);
        this.type = type;
        allConsumeBg = ContextCompat.getDrawable(context, R.drawable.shape_oval_48);
        expiredBg = ContextCompat.getDrawable(context, R.drawable.shape_oval_red_wine);
        willExpireSoonBg = ContextCompat.getDrawable(context, R.drawable.shape_oval_bright_orange);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, WarehouseDetailsBean purchaseWarehousingOrderDetailsContentsBean) {
        //食品名
        viewHolder.setText(R.id.tv_warehouse_details_food_name, purchaseWarehousingOrderDetailsContentsBean.getName());
        //入庫單位
        viewHolder.setText(R.id.tv_warehouse_details_food_unit, purchaseWarehousingOrderDetailsContentsBean.getUnitName());
        //入庫食品數量
//        if (purchaseWarehousingOrderDetailsContentsBean.getFoodQuantity() > 0) {
        if (type == WarehouseDetailsFragment.WAREHOUSE_TYPE) {
            // 入庫，顯示+
            if (purchaseWarehousingOrderDetailsContentsBean.getFoodQuantity() >= 0) {
                //如果大於0，前面顯示+號
                viewHolder.setText(R.id.tv_warehouse_details_food_num, String.format(getContext().getString(R.string.str_format_positive), MoneyUtil.formatDouble(purchaseWarehousingOrderDetailsContentsBean.getFoodQuantity())));
            } else {
                //小於0，直接顯示負數
                viewHolder.setText(R.id.tv_warehouse_details_food_num, String.valueOf(purchaseWarehousingOrderDetailsContentsBean.getFoodQuantity()));
            }
            viewHolder.setGone(R.id.tv_warehouse_time_text, false);
            viewHolder.setText(R.id.tv_warehouse_order_time_text, "下單日期：");
            //入庫日期
            viewHolder.setText(R.id.tv_warehouse_details_time, purchaseWarehousingOrderDetailsContentsBean.getWarehousingTime());
        } else {
            //出庫，顯示-
            if (purchaseWarehousingOrderDetailsContentsBean.getFoodQuantity() >= 0) {
                //如果大於0，前面顯示-號
                viewHolder.setText(R.id.tv_warehouse_details_food_num, String.format(getContext().getString(R.string.str_format_less), MoneyUtil.formatDouble(purchaseWarehousingOrderDetailsContentsBean.getFoodQuantity())));
            } else {
                //小於0，直接顯示負數
                viewHolder.setText(R.id.tv_warehouse_details_food_num, String.valueOf(purchaseWarehousingOrderDetailsContentsBean.getFoodQuantity()));
            }
            // 入庫顯示消耗日期，不顯示入庫日期
            viewHolder.setGone(R.id.tv_warehouse_time_text, true);
            //消耗日期
            viewHolder.setText(R.id.tv_warehouse_order_time_text, "消耗日期：");
        }
        //下單時間
        viewHolder.setText(R.id.tv_warehouse_details_order_time, purchaseWarehousingOrderDetailsContentsBean.getPurchaseTime());
        //供應商
        viewHolder.setText(R.id.tv_warehouse_details_supplier, purchaseWarehousingOrderDetailsContentsBean.getSupplierName());
        //入庫來源
        viewHolder.setText(R.id.tv_warehouse_details_reason, purchaseWarehousingOrderDetailsContentsBean.getPurchase());
        //設置狀態
        TextView tvState = viewHolder.getView(R.id.tv_warehouse_state);
        tvState.setVisibility(View.VISIBLE);
        if (purchaseWarehousingOrderDetailsContentsBean.getConsumeStatus() == WarehouseDetailsBean.WAREHOUSE_STATE_ALL_CONSUMED) {
            //全部消耗了
            tvState.setBackground(allConsumeBg);
            tvState.setText("庫存已使用");
        } else {
            if (purchaseWarehousingOrderDetailsContentsBean.getDistanceExpiresTime() >= 0) {
                //即將過期天數大於等於0
                if (purchaseWarehousingOrderDetailsContentsBean.getWarningDays() > purchaseWarehousingOrderDetailsContentsBean.getDistanceExpiresTime()) {
                    //在預警天數內
                    //顯示即將過期
                    tvState.setBackground(willExpireSoonBg);
                    tvState.setText("即将過期：" + purchaseWarehousingOrderDetailsContentsBean.getDistanceExpiresTime() + "日");
                } else {
                    tvState.setVisibility(View.GONE);
                }
            } else {
                //天數為負，則是已過期
                tvState.setBackground(expiredBg);
                tvState.setText("已過期：" + Math.abs(purchaseWarehousingOrderDetailsContentsBean.getDistanceExpiresTime()) + "日");
            }
        }
    }

    public void setType(int type) {
        this.type = type;
    }
}
