package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.text.Editable;
import android.text.InputFilter;
import android.text.InputType;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.adapter.bean.MultiInputBean;
import com.google.android.material.textfield.TextInputEditText;

import org.jetbrains.annotations.NotNull;

import butterknife.ButterKnife;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/29
 * Time: 15:58
 * Use:
 */
public class InputProvider<T extends InfoMultiBean> extends MyBaseItemProvider<T> {

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_TYPE_INPUT;
    }

    @Override
    public int getLayoutId() {
        return R.layout.multi_input;
    }

    @Override
    public @NotNull InputViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        return new InputViewHolder(LayoutInflater.from(context).inflate(getLayoutId(), parent, false));
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T t) {
        super.convert(baseViewHolder, t);
        InputViewHolder viewHolder = (InputViewHolder) baseViewHolder;
        MultiInputBean infoMultiBean = (MultiInputBean) t;

        TextInputEditText editText = baseViewHolder.getView(R.id.ed_multi_value);
        initEditFocusable(infoMultiBean, editText);
        //設置輸入限制
        setFilters(editText, infoMultiBean);
        //刷新數據
        viewHolder.updateView(infoMultiBean);
        //設置輸入框的值
        initEditText(editText, infoMultiBean.getShowValue(), infoMultiBean.getHintText());
        //添加焦點監聽
        editText.setOnFocusChangeListener((v, hasFocus) -> {
            if (getAdapter() != null) {
                T infoBean = getAdapter().getData().get(baseViewHolder.getAdapterPosition());
                if (infoBean instanceof MultiInputBean) {
                    MultiInputBean currentInputBean = (MultiInputBean) infoBean;
                    if (currentInputBean.getOnFocusChangeListener() != null) {
                        currentInputBean.getOnFocusChangeListener().onFocusChange(v, hasFocus);
                    }
                }
            }
        });

    }

    private void initEditFocusable(MultiInputBean infoMultiBean, TextInputEditText editText) {
        //是否可編輯
        editText.setFocusable(infoMultiBean.isEdit());
        if (infoMultiBean.isEdit()) {
            editText.setTextColor(ContextCompat.getColor(context, R.color.color_3c));
        } else {
            editText.setTextColor(ContextCompat.getColor(context, R.color.color_ef));
        }
    }

    private void initEditText(EditText tvThird, String showValue, String hintText) {
        tvThird.setText(showValue);
        tvThird.setHint(hintText);
    }

    private void setFilters(EditText editText, MultiInputBean multiSelectBean) {
        //輸入攔截器
        editText.setFilters(multiSelectBean.getInputFilters());
        //輸入類型限制
        editText.setInputType(multiSelectBean.getInputType());
    }


    public class InputViewHolder extends BaseViewHolder {
        public InputTextWatcher inputTextWatcher = new InputTextWatcher();
        private TextInputEditText editText;

        public InputViewHolder(@NotNull View view) {
            super(view);
            ButterKnife.bind(this, view);
            editText = view.findViewById(R.id.ed_multi_value);
            editText.addTextChangedListener(inputTextWatcher);
        }

        public void updateView(MultiInputBean infoMultiBean) {
            inputTextWatcher.inputViewHolder = this;
            inputTextWatcher.infoMultiBean = infoMultiBean;
        }
    }

    class InputTextWatcher implements TextWatcher {
        MultiInputBean infoMultiBean;
        InputViewHolder inputViewHolder;

        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        @Override
        public void afterTextChanged(Editable s) {
            if (infoMultiBean != null) {
                infoMultiBean.setShowValue(s + "");
            }
        }
    }
}
