package com.joe.print.mvp.print;

import android.util.SparseArray;

import com.gingersoft.gsa.cloud.common.constans.PrintConstans;

/**
 * @作者: bin
 * @創建時間: 2021-03-26 18:23
 * @更新時間: 2021-03-26 18:23
 * @描述:
 */
public class PrinterFactory {

    private static SparseArray<PrinterRoot> mPrinters = new SparseArray<>();

    static {
        mPrinters.put(PrintConstans.PRINT_TEST, new PrintTest());
        mPrinters.put(PrintConstans.PRINT_SERVE, new PrintServe());
        mPrinters.put(PrintConstans.PRINT_SLIP, new PrintSlip());
        mPrinters.put(PrintConstans.PRINT_BILL, new PrintBill());
        mPrinters.put(PrintConstans.PRINT_KITCHEN, new PrintPrjKitchen());
        mPrinters.put(PrintConstans.PRINT_CLEAN_MACHINE, new PrintCleanMachine());
        mPrinters.put(PrintConstans.PRINT_OTHER_ORDER, new PrintOtherOrder());
        mPrinters.put(PrintConstans.PRINT_INSTRUCTION, new PrintInstruction());
        mPrinters.put(PrintConstans.PRINT_OTHER_CLOSING, new PrintOtherOrderClosing());
        mPrinters.put(PrintConstans.PRINT_SKYORDER_QRCODE, new PrintQRCode());
    }

    public static PrinterRoot create(int type){
        PrinterRoot printerRoot = mPrinters.get(type);
        return printerRoot;
    }
}
