package com.gingersoft.gsa.cloud.table.mvp.contract;

import android.app.Activity;
import android.widget.BaseAdapter;

import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import io.reactivex.Single;
import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:17
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface MealStandContract2 {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends BaseOrderContract.View {

        void showStandOperLayoutVisibility(boolean show);

        void showBtnMealModifyRestoreVisibility(boolean show);

        void setOrderFoodCount(String number);

        Activity getActivity();

        int getFromType();
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends BaseOrderContract.Model {

        Single<BaseResult> getCurrentSoldoutFood(RequestBody requestBody);

        Single<BaseResult> createOrder(RequestBody requestBody);

        Single<BaseResult> addOrderFood(RequestBody requestBody);

        Single<BaseOrderResponse> loadOrder(long orderId);

        Single<BaseOrderResponse> deleteFood(RequestBody requestBody);

        Single<BaseOrderResponse> printOrder(RequestBody requestBody);

        Single<BaseResult> getRestaurantFoodReason(int brandId, int restaurantId, int type);

        Single<BaseResult> queryMember(int type, String parm, String shopName, int tableId, String tableNumber);

        Single<BaseResult> memberUse(int tableId, String tableNumber, long memberId);

        Single<BaseResult> memberUseCancel(int tableId, String tableNumber, long memberId);

        List<Food> queryDB_AllFoodList();

        List<Food> queryDB_FoodGroupList(int foodSummary);

        List<Food> queryDB_FoodList(long parentId, int foodSummary);

        List<Modifier> queryDB_ModifierList(long fid, int mode);

        List<ComboItem> queryDB_ComboList(long fid, int foodSummary);

        List<FoodCombo> isComboFood(long fid);

        List<FoodModifier> queryDB_FoodModifierList(long fid);

        List<Discount> queryDB_DiscountList(byte discountScope, byte discountType);
    }
}
