package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.ComboItemDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.DiscountDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.FoodComboDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealStandContract;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealStandContract2;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MealService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MemberService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderPayService;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.MealConditionFilterUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.MealStyleUtils;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.Single;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:17
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class MealStandModel2 extends BaseModel implements MealStandContract2.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public MealStandModel2(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public List<Food> queryDB_AllFoodList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryAllFoodByQueryBuilder();
        return foods;
    }

    @Override
    public List<Food> queryDB_FoodGroupList(int foodSummary) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodGroupByQueryBuilder(foodSummary);
        return MealStyleUtils.assemblyFoodsColor(MealConditionFilterUtils.foodConditionFilter(foods, foodSummary));
    }

    @Override
    public List<Food> queryDB_FoodList(long parentId, int foodSummary) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodByQueryBuilder(parentId, foodSummary);
        return MealStyleUtils.assemblyFoodsColor(MealConditionFilterUtils.foodConditionFilter(foods, foodSummary));
    }

    @Override
    public List<Modifier> queryDB_ModifierList(long fid, int mode) {
        ModifierDaoUtils daoUtils = new ModifierDaoUtils(mApplication);
        return MealStyleUtils.assemblyModifiersColor(daoUtils.queryModifiersByFid(fid, mode));
    }

    @Override
    public List<ComboItem> queryDB_ComboList(long fid, int foodSummary) {
        ComboItemDaoUtils comboItemDao = new ComboItemDaoUtils(mApplication);
        List<ComboItem> foodCombos = comboItemDao.queryComboItemsByFidQueryBuilder(fid, foodSummary);
        return MealConditionFilterUtils.comboConditionFilter(foodCombos, foodSummary);
    }

    @Override
    public List<FoodCombo> isComboFood(long fid) {
        FoodComboDaoUtils foodComboDaoUtils = new FoodComboDaoUtils(mApplication);
        return foodComboDaoUtils.queryCombosFoodsByQueryBuilder(fid);
    }

    @Override
    public List<FoodModifier> queryDB_FoodModifierList(long fid) {
        return null;
    }

    @Override
    public List<Discount> queryDB_DiscountList(byte discountScope, byte discountType) {
        DiscountDaoUtils discountDaoUtils = new DiscountDaoUtils(mApplication);
        List<Discount> discountList = discountDaoUtils.queryDiscountByQueryBuilder();
        return MealConditionFilterUtils.discountConditionFilter(discountList, discountScope, discountType);
    }

    @Override
    public Single<BaseResult> getCurrentSoldoutFood(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .getCurrentSoldoutFood(requestBody);
    }

    @Override
    public Single<BaseOrderResponse> loadOrder(long orderId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .loadOrder(orderId);
    }

    @Override
    public Single<BaseResult> createOrder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .createOrder(requestBody);
    }

    @Override
    public Single<BaseResult> addOrderFood(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .addOrderFood(requestBody);
    }

    @Override
    public Single<BaseOrderResponse> deleteFood(RequestBody requestBody) {
        Single ob = mRepositoryManager.obtainRetrofitService(MealService.class)
                .deleteFood(requestBody)
                .flatMap(new Function<BaseResult, Single<BaseOrderResponse>>() {
                    @Override
                    public Single<BaseOrderResponse> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return loadOrder(DoshokuOrder.getInstance().getOrderId());
                        }
                        BaseOrderResponse baseOrderRespose = new BaseOrderResponse();
                        baseOrderRespose.setSuccess(info.isSuccess());
                        baseOrderRespose.setErrMsg(info.getErrMsg());
                        return Single.just(baseOrderRespose);
                    }
                });
        return ob;
    }

    @Override
    public Single<BaseOrderResponse> calculationPrice(long orderId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .calculationPrice(orderId);
    }

    @Override
    public Single<BaseOrderResponse> printOrder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .printOrder(requestBody);
    }

    @Override
    public Single<BaseResult> getRestaurantFoodReason(int brandId, int restaurantId, int type) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .getRestaurantFoodReason(brandId, restaurantId, type);
    }

    @Override
    public Single<BaseResult> queryMember(int type, String parm, String shopName, int tableId, String tableNumber) {
        return mRepositoryManager.obtainRetrofitService(MemberService.class)
                .queryMember(type, parm, shopName, tableId, tableNumber);
    }

    @Override
    public Single<BaseResult> memberUse(int tableId, String tableNumber, long memberId) {
        return mRepositoryManager.obtainRetrofitService(MemberService.class)
                .memberUse(tableId, tableNumber, memberId);
    }

    @Override
    public Single<BaseResult> memberUseCancel(int tableId, String tableNumber, long memberId) {
        return mRepositoryManager.obtainRetrofitService(MemberService.class)
                .memberUseCancel(tableId, tableNumber, memberId);
    }

    @Override
    public Single<BaseResult> toOrderPay(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .toOrderPay(requestBody);
    }

    @Override
    public Single<BaseResult> updateOrder(RequestBody formBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .updateOrder(formBody);
    }
}