package com.gingersoft.gsa.cloud.table.mvp.model.service;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import io.reactivex.Single;
import io.reactivex.Single;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019-12-28
 * 修订历史：2019-12-28
 * 描述：
 */
public interface TableService {

    @GET("restaurantTable/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<TableBean> getTables(@Query("restaurantId") int restaurantId);

    @GET("restaurantTable/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getTable(@Query("id") int table, @Query("tableNumber") String tableNumber);

    @POST("restaurantTable/kickOff" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseOrderResponse> openTable(@Body RequestBody requestBody);

    @POST("restaurantTable/update/table" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseOrderResponse> turnTable(@Body RequestBody requestBody);

    @POST("restaurantTable/set/status" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseOrderResponse> initTable(@Body RequestBody requestBody);

    @POST("restaurantTable/skyOrderReset" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> resetSkyorder(@Body RequestBody requestBody);

    @GET("restaurantTable/getSplitTableAvailable" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getSplitTables(@Query("tableId") int tableId);

    @GET("restaurantTable/getSplitTable" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> splitTable(@Query("tableId") int tableId);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @GET("summary/getSummaryBusinessList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getFoodSummarys(@Query("restaurantId") int restaurantId, @Query("isDefault") boolean isDefault, @Query("businessType") byte businessType);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @POST("scan/addScanCloudGsa" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> addScan(@Body RequestBody requestBody);
}
