package com.gingersoft.gsa.cloud.table.mvp.ui.fragment.discount;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.gingersoft.gsa.cloud.common.loadsir.EmptyCallback;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerNomalDiscountComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.NomalDiscountContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.discount.NomalDiscountPresenter;
import com.gingersoft.gsa.cloud.ui.adapter.TagViewAdapter;
import com.gingersoft.gsa.cloud.ui.bean.TagViewItem;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.kingja.loadsir.core.LoadService;
import com.kingja.loadsir.core.LoadSir;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;

/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/02/2021 17:26
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class NomalDiscountFragment extends BaseFragment<NomalDiscountPresenter> implements NomalDiscountContract.View {

    @BindView(R2.id.rv_bill_discount)
    RecyclerView rvBillDiscount;

    @Inject
    List<TagViewItem> mBillDiscountList;
    @Inject
    TagViewAdapter mBillDiscountAdapter;

    private LoadService loadService;

    public static NomalDiscountFragment newInstance() {
        NomalDiscountFragment fragment = new NomalDiscountFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerNomalDiscountComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_bill_discount, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        loadService = LoadSir.getDefault().register(rvBillDiscount);

        initAdapter();
        mPresenter.queryBillDiscountList();
    }

    private void initAdapter() {
        rvBillDiscount.setLayoutManager(createLayoutManager());
        rvBillDiscount.setAdapter(mBillDiscountAdapter);
        mBillDiscountAdapter.setOnItemClickListener((adapter, view, position) -> {
            if (onDiscountItemClickListener != null) {
                onDiscountItemClickListener.onItemClick((Discount) mBillDiscountList.get(position).getTargetObj(), position);
            }
        });
    }

    private RecyclerView.LayoutManager createLayoutManager() {
        return new GridLayoutManager(mContext, 3, LinearLayoutManager.VERTICAL, false) {
            @Override
            public RecyclerView.LayoutParams generateDefaultLayoutParams() {
                return new RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            }
        };
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(_mActivity, message, true);
        else
            LoadingDialog.showDialogForLoading(_mActivity);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(_mActivity, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        if (intent != null) {
            ArmsUtils.startActivity(intent);
        }
    }

    @Override
    public void killMyself() {
        _mActivity.onBackPressedSupport();
    }

    @Override
    public void returnBillCoupon(List<Discount> discounts) {
        List<TagViewItem> tagViewItems = castTagItem(discounts);
        if (tagViewItems.size() > 0) {
            loadService.showSuccess();
        } else {
            loadService.showCallback(EmptyCallback.class);
        }
        if (mBillDiscountList.size() > 0) {
            mBillDiscountList.clear();
        }
        mBillDiscountList.addAll(tagViewItems);
        mBillDiscountAdapter.notifyDataSetChanged();
    }

    private List<TagViewItem> castTagItem(List<Discount> discountList) {
        List<TagViewItem> tagViewItems = new ArrayList<>();
        for (Discount discount : discountList) {
            TagViewItem<Discount> tagViewItem = new TagViewItem();
            tagViewItem.setId(discount.getId());
            tagViewItem.setText(discount.getRemark());
            tagViewItem.setTargetObj(discount);
            tagViewItems.add(tagViewItem);
        }
        return tagViewItems;
    }

    private OnBillDiscountItemClickListener onDiscountItemClickListener;

    public void setOnDiscountItemClickListener(OnBillDiscountItemClickListener onDiscountItemClickListener) {
        this.onDiscountItemClickListener = onDiscountItemClickListener;
    }

    public interface OnBillDiscountItemClickListener {
        void onItemClick(Discount item, int position);
    }
}
