package com.gingersoft.gsa.cloud.common.core.member;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

import java.io.Serializable;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-07-25
 * 修订历史：2020-07-25
 * 描述：
 */
@Data
public class MemberInfo implements Parcelable {

    /**
     * ablediscount : 0
     * birthdaybonusratio : 1
     * birthdayperiod : 5
     * brCouponNum : 0
     * brCouponTypeId : 0
     * brPoints : 5
     * brandId : 0
     * brandName : Gingersoft
     * couponTypeId : 0
     * createBy : H5
     * createTime : {"date":28,"day":4,"hours":17,"minutes":53,"month":4,"seconds":37,"time":1590659617000,"timezoneOffset":-480,"year":120}
     * createTimes : 0
     * creditPoints : 0
     * discount : 0
     * expireAfterDayClearPoints : 0
     * extendExpireAmount : 1
     * extendExpirePeriod : 365
     * extendValidDays : 0
     * foodDesc1 : GS白金會員
     * foodDesc2 : GS白金會員
     * foodDesc3 : GS白金會員
     * foodPrice : 500
     * groupId : 7
     * id : 421439
     * isDisplay : 0
     * isVisible : 1
     * isdefault : 1
     * language : 0
     * level : 0
     * levelDesc : 60日內消費滿3000, 可升級為白金會員享有更多折扣會員享有更多折扣
     * levelName :
     * levelName1 : GS基本用戶
     * levelName2 : 基本用戶
     * levelName3 : 基本用戶
     * levelUpAmount : 1
     * levelUpPeriod : 365
     * negativePoints : 0
     * newCouponNum : 0
     * nextDownLevel : 35
     * nextUpLevel : 0
     * optTime : {"date":25,"day":6,"hours":9,"minutes":48,"month":6,"seconds":50,"time":1595641730781,"timezoneOffset":-480,"year":120}
     * optTimes : 0
     * pointRedeemCash : 20
     * pointRule : 2
     * pointUnit : 1
     * pointenddate :
     * pointoveryear : 0
     * points : 0
     * pointsVariable : 50
     * restaurantId : 2
     * scCharge : 0
     * seq1 : 3
     * sid :
     * updateBy : H5
     * updateTime : {"date":23,"day":4,"hours":17,"minutes":33,"month":6,"seconds":14,"time":1595496794000,"timezoneOffset":-480,"year":120}
     * updateTimes : 0
     * vaildDays : 0
     * adverHeight : 0
     * advertCol : 1
     * birthday :
     * birthdays :
     * brandImgUrl : http://m.ricepon.com/1/20160816/20160816133220847.png
     * brandMemberInfoIcon : http://m.ricepon.com/ricepon-asset/images/1546398451087.png
     * consumeAmount : 0
     * consumePoints : 3
     * countryId : 0
     * districtId : 0
     * districtName :
     * email :
     * emailActive : 0
     * headImg :
     * imgPath :
     * isPush : 0
     * levelImgUrl : http://m.ricepon.com/ricepon-asset/201912/member/member-1575525134386.jpg
     * levelTime :
     * memberDiscount : 20
     * memberExpireDate : {"date":25,"day":6,"hours":9,"minutes":48,"month":6,"seconds":50,"time":1595641730781,"timezoneOffset":-480,"year":120}
     * memberId : 0
     * memberName :
     * memberNo : 2005149175337
     * memberNote :
     * memberPoint : 3
     * memberTypeId : 32
     * openId :
     * password :
     * phone : 18218743523
     * postcardNo :
     * postcardType : 1
     * proId : 0
     * proName :
     * secretKey :
     * serviceOpenId :
     * sex : 0
     * shopCanUse :
     * shopId :
     * shopNote :
     * source : 0
     * status : 0
     * type : 0
     * vaildTime : {"date":25,"day":6,"hours":9,"minutes":48,"month":6,"seconds":50,"time":1595641730781,"timezoneOffset":-480,"year":120}
     * MemberPoint : 3
     */

    private long id;
    private String memberNo;
    /**會員折扣比例*/
    private int memberDiscount;
    //获取会员信息接口
    private float MemberPoint;
    //开台接口返回
    private float memberPoint;
    private String memberName = "";
    private String levelName3;
    private String levelName2;
    private String levelName1;
    private String levelName;
    private String phone;
    private int birthdaybonusratio;
    private int creditPoints;
    private int birthdayperiod;
    private int extendExpirePeriod;
    private int brCouponTypeId;
    private int levelUpPeriod;
    private int groupId;
    private int seq1;
    private int nextDownLevel;
    private int discount;
    private int language;
    private int points;
    private int negativePoints;
    private int couponTypeId;
    private int isdefault;
    private int pointsVariable;
    private String brandName;
    private int level;
    private int newCouponNum;
    private int isVisible;
    private int isDisplay;
    private int vaildDays;
    private int brandId;
    /**積分兌換現金列*/
    private float pointRedeemCash;
    private int ablediscount;
    private float expireAfterDayClearPoints;
    private double extendExpireAmount;
    private String foodDesc3;
    private int scCharge;
    private int extendValidDays;
    private double levelUpAmount;
    private int optTimes;
    private int updateTimes;
    private String foodDesc1;
    private String foodDesc2;
    private String sid;
    private String pointenddate;
    private String updateBy;
    private int brPoints;
    private String optTime;
    private int createTimes;
    private int brCouponNum;
    private int pointRule;
    private int foodPrice;
    private String createBy;
    private int pointoveryear;
    private String levelDesc;
    private int pointUnit;
    private int nextUpLevel;
    private int restaurantId = 2;
    private CreateTimeBean createTime;
    private UpdateTimeBean updateTime;
    private MemberExpireDateBean memberExpireDate;
    private VaildTimeBean vaildTime;

    public MemberInfo() {
    }

    public String getLevelName(){
        if(!TextUtils.isEmpty(levelName1)) {
            return levelName1;
        }
        if(!TextUtils.isEmpty(levelName2)) {
            return levelName2;
        }
        if(!TextUtils.isEmpty(levelName3)) {
            return levelName3;
        }
        return "";
    }

    public float getMemberPoint() {
        if (MemberPoint != 0) {
            return MemberPoint;
        }
        if (memberPoint != 0) {
            return memberPoint;
        }
        return 0;
    }

    public String getMemberName() {
        if(!TextUtils.isEmpty(memberName)){
            return memberName;
        }
        return getLevelName();
    }




    @Data
    public static class CreateTimeBean implements Parcelable{
        /**
         * date : 28
         * day : 4
         * hours : 17
         * minutes : 53
         * month : 4
         * seconds : 37
         * time : 1590659617000
         * timezoneOffset : -480
         * year : 120
         */

        private int date;
        private int day;
        private int hours;
        private int minutes;
        private int month;
        private int seconds;
        private long time;
        private int timezoneOffset;
        private int year;


        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.date);
            dest.writeInt(this.day);
            dest.writeInt(this.hours);
            dest.writeInt(this.minutes);
            dest.writeInt(this.month);
            dest.writeInt(this.seconds);
            dest.writeLong(this.time);
            dest.writeInt(this.timezoneOffset);
            dest.writeInt(this.year);
        }

        protected CreateTimeBean(Parcel in) {
            this.date = in.readInt();
            this.day = in.readInt();
            this.hours = in.readInt();
            this.minutes = in.readInt();
            this.month = in.readInt();
            this.seconds = in.readInt();
            this.time = in.readLong();
            this.timezoneOffset = in.readInt();
            this.year = in.readInt();
        }

        public static final Creator<CreateTimeBean> CREATOR = new Creator<CreateTimeBean>() {
            @Override
            public CreateTimeBean createFromParcel(Parcel source) {
                return new CreateTimeBean(source);
            }

            @Override
            public CreateTimeBean[] newArray(int size) {
                return new CreateTimeBean[size];
            }
        };
    }

    @Data
    public static class OptTimeBean  implements Parcelable{
        /**
         * date : 25
         * day : 6
         * hours : 9
         * minutes : 48
         * month : 6
         * seconds : 50
         * time : 1595641730781
         * timezoneOffset : -480
         * year : 120
         */
        private int date;
        private int day;
        private int hours;
        private int minutes;
        private int month;
        private int seconds;
        private long time;
        private int timezoneOffset;
        private int year;


        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.date);
            dest.writeInt(this.day);
            dest.writeInt(this.hours);
            dest.writeInt(this.minutes);
            dest.writeInt(this.month);
            dest.writeInt(this.seconds);
            dest.writeLong(this.time);
            dest.writeInt(this.timezoneOffset);
            dest.writeInt(this.year);
        }

        protected OptTimeBean(Parcel in) {
            this.date = in.readInt();
            this.day = in.readInt();
            this.hours = in.readInt();
            this.minutes = in.readInt();
            this.month = in.readInt();
            this.seconds = in.readInt();
            this.time = in.readLong();
            this.timezoneOffset = in.readInt();
            this.year = in.readInt();
        }

        public static final Creator<OptTimeBean> CREATOR = new Creator<OptTimeBean>() {
            @Override
            public OptTimeBean createFromParcel(Parcel source) {
                return new OptTimeBean(source);
            }

            @Override
            public OptTimeBean[] newArray(int size) {
                return new OptTimeBean[size];
            }
        };
    }

    @Data
    public static class UpdateTimeBean  implements Parcelable{
        /**
         * date : 23
         * day : 4
         * hours : 17
         * minutes : 33
         * month : 6
         * seconds : 14
         * time : 1595496794000
         * timezoneOffset : -480
         * year : 120
         */
        private int date;
        private int day;
        private int hours;
        private int minutes;
        private int month;
        private int seconds;
        private long time;
        private int timezoneOffset;
        private int year;


        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.date);
            dest.writeInt(this.day);
            dest.writeInt(this.hours);
            dest.writeInt(this.minutes);
            dest.writeInt(this.month);
            dest.writeInt(this.seconds);
            dest.writeLong(this.time);
            dest.writeInt(this.timezoneOffset);
            dest.writeInt(this.year);
        }

        protected UpdateTimeBean(Parcel in) {
            this.date = in.readInt();
            this.day = in.readInt();
            this.hours = in.readInt();
            this.minutes = in.readInt();
            this.month = in.readInt();
            this.seconds = in.readInt();
            this.time = in.readLong();
            this.timezoneOffset = in.readInt();
            this.year = in.readInt();
        }

        public static final Creator<UpdateTimeBean> CREATOR = new Creator<UpdateTimeBean>() {
            @Override
            public UpdateTimeBean createFromParcel(Parcel source) {
                return new UpdateTimeBean(source);
            }

            @Override
            public UpdateTimeBean[] newArray(int size) {
                return new UpdateTimeBean[size];
            }
        };
    }

    @Data
    public static class MemberExpireDateBean  implements Parcelable{
        /**
         * date : 25
         * day : 6
         * hours : 9
         * minutes : 48
         * month : 6
         * seconds : 50
         * time : 1595641730781
         * timezoneOffset : -480
         * year : 120
         */

        private int date;
        private int day;
        private int hours;
        private int minutes;
        private int month;
        private int seconds;
        private long time;
        private int timezoneOffset;
        private int year;

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.date);
            dest.writeInt(this.day);
            dest.writeInt(this.hours);
            dest.writeInt(this.minutes);
            dest.writeInt(this.month);
            dest.writeInt(this.seconds);
            dest.writeLong(this.time);
            dest.writeInt(this.timezoneOffset);
            dest.writeInt(this.year);
        }

        protected MemberExpireDateBean(Parcel in) {
            this.date = in.readInt();
            this.day = in.readInt();
            this.hours = in.readInt();
            this.minutes = in.readInt();
            this.month = in.readInt();
            this.seconds = in.readInt();
            this.time = in.readLong();
            this.timezoneOffset = in.readInt();
            this.year = in.readInt();
        }

        public static final Creator<MemberExpireDateBean> CREATOR = new Creator<MemberExpireDateBean>() {
            @Override
            public MemberExpireDateBean createFromParcel(Parcel source) {
                return new MemberExpireDateBean(source);
            }

            @Override
            public MemberExpireDateBean[] newArray(int size) {
                return new MemberExpireDateBean[size];
            }
        };
    }

    @Data
    public static class VaildTimeBean  implements Parcelable{
        /**
         * date : 25
         * day : 6
         * hours : 9
         * minutes : 48
         * month : 6
         * seconds : 50
         * time : 1595641730781
         * timezoneOffset : -480
         * year : 120
         */

        private int date;
        private int day;
        private int hours;
        private int minutes;
        private int month;
        private int seconds;
        private long time;
        private int timezoneOffset;
        private int year;


        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.date);
            dest.writeInt(this.day);
            dest.writeInt(this.hours);
            dest.writeInt(this.minutes);
            dest.writeInt(this.month);
            dest.writeInt(this.seconds);
            dest.writeLong(this.time);
            dest.writeInt(this.timezoneOffset);
            dest.writeInt(this.year);
        }

        protected VaildTimeBean(Parcel in) {
            this.date = in.readInt();
            this.day = in.readInt();
            this.hours = in.readInt();
            this.minutes = in.readInt();
            this.month = in.readInt();
            this.seconds = in.readInt();
            this.time = in.readLong();
            this.timezoneOffset = in.readInt();
            this.year = in.readInt();
        }

        public static final Creator<VaildTimeBean> CREATOR = new Creator<VaildTimeBean>() {
            @Override
            public VaildTimeBean createFromParcel(Parcel source) {
                return new VaildTimeBean(source);
            }

            @Override
            public VaildTimeBean[] newArray(int size) {
                return new VaildTimeBean[size];
            }
        };
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.memberNo);
        dest.writeInt(this.memberDiscount);
        dest.writeFloat(this.MemberPoint);
        dest.writeFloat(this.memberPoint);
        dest.writeString(this.memberName);
        dest.writeString(this.levelName3);
        dest.writeString(this.levelName2);
        dest.writeString(this.levelName1);
        dest.writeString(this.levelName);
        dest.writeString(this.phone);
        dest.writeInt(this.birthdaybonusratio);
        dest.writeInt(this.creditPoints);
        dest.writeInt(this.birthdayperiod);
        dest.writeInt(this.extendExpirePeriod);
        dest.writeInt(this.brCouponTypeId);
        dest.writeInt(this.levelUpPeriod);
        dest.writeInt(this.groupId);
        dest.writeInt(this.seq1);
        dest.writeInt(this.nextDownLevel);
        dest.writeInt(this.discount);
        dest.writeInt(this.language);
        dest.writeInt(this.points);
        dest.writeInt(this.negativePoints);
        dest.writeInt(this.couponTypeId);
        dest.writeInt(this.isdefault);
        dest.writeInt(this.pointsVariable);
        dest.writeString(this.brandName);
        dest.writeInt(this.level);
        dest.writeInt(this.newCouponNum);
        dest.writeInt(this.isVisible);
        dest.writeInt(this.isDisplay);
        dest.writeInt(this.vaildDays);
        dest.writeInt(this.brandId);
        dest.writeFloat(this.pointRedeemCash);
        dest.writeInt(this.ablediscount);
        dest.writeFloat(this.expireAfterDayClearPoints);
        dest.writeDouble(this.extendExpireAmount);
        dest.writeString(this.foodDesc3);
        dest.writeInt(this.scCharge);
        dest.writeInt(this.extendValidDays);
        dest.writeDouble(this.levelUpAmount);
        dest.writeInt(this.optTimes);
        dest.writeInt(this.updateTimes);
        dest.writeString(this.foodDesc1);
        dest.writeString(this.foodDesc2);
        dest.writeString(this.sid);
        dest.writeString(this.pointenddate);
        dest.writeString(this.updateBy);
        dest.writeInt(this.brPoints);
        dest.writeString(this.optTime);
        dest.writeInt(this.createTimes);
        dest.writeInt(this.brCouponNum);
        dest.writeInt(this.pointRule);
        dest.writeInt(this.foodPrice);
        dest.writeString(this.createBy);
        dest.writeInt(this.pointoveryear);
        dest.writeString(this.levelDesc);
        dest.writeInt(this.pointUnit);
        dest.writeInt(this.nextUpLevel);
        dest.writeInt(this.restaurantId);
        dest.writeParcelable(this.createTime, flags);
        dest.writeParcelable(this.updateTime, flags);
        dest.writeParcelable(this.memberExpireDate, flags);
        dest.writeParcelable(this.vaildTime, flags);
    }

    protected MemberInfo(Parcel in) {
        this.id = in.readLong();
        this.memberNo = in.readString();
        this.memberDiscount = in.readInt();
        this.MemberPoint = in.readFloat();
        this.memberPoint = in.readFloat();
        this.memberName = in.readString();
        this.levelName3 = in.readString();
        this.levelName2 = in.readString();
        this.levelName1 = in.readString();
        this.levelName = in.readString();
        this.phone = in.readString();
        this.birthdaybonusratio = in.readInt();
        this.creditPoints = in.readInt();
        this.birthdayperiod = in.readInt();
        this.extendExpirePeriod = in.readInt();
        this.brCouponTypeId = in.readInt();
        this.levelUpPeriod = in.readInt();
        this.groupId = in.readInt();
        this.seq1 = in.readInt();
        this.nextDownLevel = in.readInt();
        this.discount = in.readInt();
        this.language = in.readInt();
        this.points = in.readInt();
        this.negativePoints = in.readInt();
        this.couponTypeId = in.readInt();
        this.isdefault = in.readInt();
        this.pointsVariable = in.readInt();
        this.brandName = in.readString();
        this.level = in.readInt();
        this.newCouponNum = in.readInt();
        this.isVisible = in.readInt();
        this.isDisplay = in.readInt();
        this.vaildDays = in.readInt();
        this.brandId = in.readInt();
        this.pointRedeemCash = in.readFloat();
        this.ablediscount = in.readInt();
        this.expireAfterDayClearPoints = in.readFloat();
        this.extendExpireAmount = in.readDouble();
        this.foodDesc3 = in.readString();
        this.scCharge = in.readInt();
        this.extendValidDays = in.readInt();
        this.levelUpAmount = in.readDouble();
        this.optTimes = in.readInt();
        this.updateTimes = in.readInt();
        this.foodDesc1 = in.readString();
        this.foodDesc2 = in.readString();
        this.sid = in.readString();
        this.pointenddate = in.readString();
        this.updateBy = in.readString();
        this.brPoints = in.readInt();
        this.optTime = in.readString();
        this.createTimes = in.readInt();
        this.brCouponNum = in.readInt();
        this.pointRule = in.readInt();
        this.foodPrice = in.readInt();
        this.createBy = in.readString();
        this.pointoveryear = in.readInt();
        this.levelDesc = in.readString();
        this.pointUnit = in.readInt();
        this.nextUpLevel = in.readInt();
        this.restaurantId = in.readInt();
        this.createTime = in.readParcelable(CreateTimeBean.class.getClassLoader());
        this.updateTime = in.readParcelable(UpdateTimeBean.class.getClassLoader());
        this.memberExpireDate = in.readParcelable(MemberExpireDateBean.class.getClassLoader());
        this.vaildTime = in.readParcelable(VaildTimeBean.class.getClassLoader());
    }

    public static final Creator<MemberInfo> CREATOR = new Creator<MemberInfo>() {
        @Override
        public MemberInfo createFromParcel(Parcel source) {
            return new MemberInfo(source);
        }

        @Override
        public MemberInfo[] newArray(int size) {
            return new MemberInfo[size];
        }
    };
}
