package com.gingersoft.gsa.cloud.order.bean.discount;

import androidx.annotation.NonNull;

import com.gingersoft.gsa.cloud.database.AbstractDiscount;
import com.gingersoft.gsa.cloud.database.DiscountConstact;
import com.gingersoft.gsa.cloud.database.bean.Discount;

import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2021-04-07 15:45
 * @更新時間: 2021-04-07 15:45
 * @描述: 會員錢包優惠券
 */
@Data
public class MemberWalletCoupon extends AbstractDiscount implements Cloneable {

    private long id;
    private String couponTypeName;
    private String beginDate;
    private String endDate;
    private int periodDays;
    private int upperLimitTimes;
    private double billMinAmount;
    private double amount;
    private int discount;
    private String remark;
    private String couponNo;
    private int useTimes;

    public MemberWalletCoupon(MemberWalletCoupon coupon) {
        this.id = coupon.id;
        this.couponTypeName = coupon.couponTypeName;
        this.beginDate = coupon.beginDate;
        this.endDate = coupon.endDate;
        this.periodDays = coupon.periodDays;
        this.upperLimitTimes = coupon.upperLimitTimes;
        this.billMinAmount = coupon.billMinAmount;
        this.amount = coupon.amount;
        this.discount = coupon.discount;
        this.remark = coupon.remark;
        this.couponNo = coupon.couponNo;
        this.useTimes = coupon.useTimes;
    }

    public Discount castDiscount() {
        Discount discountBean = new Discount();
        discountBean.setId(id);
        discountBean.setAbstractDiscountType(DiscountConstact.WALLET_COUPON_TYPE);
        discountBean.setDiscountValue(discount);
        discountBean.setAmount(amount);
        discountBean.setMinBillAmount(billMinAmount);
        discountBean.setRemark(couponTypeName);
        discountBean.setBeginTime(beginDate);
        discountBean.setEndTime(endDate);
        return discountBean;
    }

    @NonNull
    @Override
    public MemberWalletCoupon clone() {
        try {
            return (MemberWalletCoupon) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MemberWalletCoupon(this);
    }
}