package com.gingersoft.gsa.cloud.pay;

import lombok.Getter;

/**
 * @作者: bin
 * @創建時間: 2021-04-16 10:17
 * @更新時間: 2021-04-16 10:17
 * @描述:
 */
@Getter
public enum PayStep {

    /**
     * 未支付
     * 支付中
     */
    LOADING,

    /**
     * 獲取事項ID失敗
     */
    FAILURE_OBTAIN_ID,

    /**
     * 支付成功
     */
    SUCCESS,

    /**
     * 支付失败
     */
    FAILURE,

    /**
     * 已支付未到账
     */
    NOT_ARRIVED,

    /**
     * 已退款
     */
    REFUNDED,

    /**
     * 廢棄(第二次結賬)
     */
    REPEAL

}
