package com.gingersoft.gsa.cloud.pay;

import androidx.fragment.app.FragmentManager;

import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.pay.device.pos.PosCommand;
import com.jess.arms.utils.Preconditions;

import java.util.List;

import lombok.Getter;

/**
 * @作者: bin
 * @創建時間: 2021-04-15 16:38
 * @更新時間: 2021-04-15 16:38
 * @描述:
 */
@Getter
public class PaymentCommand {

    private static PaymentCommand sPaymentControl;

    public static PaymentCommand newInstance() {
        if (sPaymentControl == null) {
            sPaymentControl = new PaymentCommand();
        }
        return sPaymentControl;
    }

    private PaymentCommand() {
    }

    public void action(FragmentManager fragmentManager, RequestParms requestParms) {
        final PayMethod currPosPaymethod = requestParms.getCurrPosPaymethod();
        if (currPosPaymethod != null) {
            final PosCommand command = PaymentFactory.createPosCommand();
            command.showActionDialog(fragmentManager, requestParms);
        } else {
            final ResultCallback resultCallback = requestParms.getResultCallback();
            if (resultCallback != null) {
                resultCallback.fakePayment();
            }
        }
    }

    public void matter(FragmentManager fragmentManager, RequestParms requestParms) {
//        final PosCommand command = PaymentFactory.createPosCommand();
//        command.showActionDialog(fragmentManager, requestParms);
    }

    public void pay(RequestParms requestParms) {
        final PosCommand command = PaymentFactory.createPosCommand();
        Preconditions.checkNotNull(command);
        command.pay(requestParms);
    }

    public void tip(RequestParms requestParms) {
        final PosCommand command = PaymentFactory.createPosCommand();
        Preconditions.checkNotNull(command);
        command.tip(requestParms);
    }

    public void refund(RequestParms requestParms) {
        final PosCommand command = PaymentFactory.createPosCommand();
        Preconditions.checkNotNull(command);
        command.refund(requestParms);
    }

    public void voidO(RequestParms requestParms) {
        final PosCommand command = PaymentFactory.createPosCommand();
        Preconditions.checkNotNull(command);
        command.void0(this);
    }

    public void retrieval(RequestParms requestParms) {
        final PosCommand command = PaymentFactory.createPosCommand();
        Preconditions.checkNotNull(command);
        command.retrieval(this);
    }

    public void printStub(RequestParms requestParms) {
        final PosCommand command = PaymentFactory.createPosCommand();
        Preconditions.checkNotNull(command);
        command.printStub(this);
    }

    public void settlement(RequestParms requestParms) {
        final PosCommand command = PaymentFactory.createPosCommand();
        Preconditions.checkNotNull(command);
        command.settlement(this);
    }


}
