import 'dart:ui';

import 'package:flutter/material.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({Key? key}) : super(key: key);

  // This widget is the root of your application.
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      // title: '12312',
      theme: ThemeData(
        primarySwatch: Colors.blue,
      ),
      home: MyTabbedPage(),
      debugShowCheckedModeBanner: false,
    );
  }
}

class MyTabbedPage extends StatefulWidget {
  const MyTabbedPage({Key? key}) : super(key: key);
  @override
  State<MyTabbedPage> createState() => _MyTabbedPageState();
}

class _MyTabbedPageState extends State<MyTabbedPage>
    with SingleTickerProviderStateMixin {
  static const List<Tab> myTabs = <Tab>[
    Tab(text: '全部'),
    Tab(text: '代付款'),
    Tab(text: '點評/投票'),
  ];

  late TabController _tabController;

  @override
  void initState() {
    super.initState();
    _tabController = TabController(vsync: this, length: myTabs.length);
  }

  @override
  void dispose() {
    _tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text('我的訂單'),
        centerTitle: true,
        bottom: TabBar(
          controller: _tabController,
          tabs: myTabs,
        ),
      ),
      body: TabBarView(
        controller: _tabController,
        children: myTabs.map((Tab tab) {
          final String label = tab.text!.toLowerCase();
          return ListView(children: <Widget>[
            Card(
              margin: EdgeInsets.all(10),
              child: Column(
                children: <Widget>[
                  ListTile(
                    leading: CircleAvatar(
                      backgroundImage: NetworkImage(
                          'https://gimg2.baidu.com/image_search/src=http%3A%2F%2Fimg.jj20.com%2Fup%2Fallimg%2F1114%2F0G320105A7%2F200G3105A7-1-1200.jpg&refer=http%3A%2F%2Fimg.jj20.com&app=2002&size=f9999,10000&q=a80&n=0&g=0n&fmt=auto?sec=1650639957&t=3cbd3f6416caf24645245a350db89db8'),
                    ),
                    title: ListTile(
                      title: Text(
                        "Gingersoft,GS2",
                        style: TextStyle(fontSize: 18),
                      ),
                      trailing: Text('訂單 以取消'),
                      subtitle: Text("2022-04-08 15:48:19"),
                    ),
                  ),
                  Divider(),
                  ListTile(
                    title: Text(
                      "(撈麵)牛腩",
                      style: TextStyle(fontSize: 14),
                    ),
                    trailing: Text(
                      'x1',
                      style: TextStyle(fontSize: 14),
                    ),
                  ),
                  ListTile(
                    trailing: Text(
                      '共 1 份，總金額 \$ 0.1',
                      style: TextStyle(fontSize: 14),
                    ),
                  ),
                  ListTile(
                    title: Text(
                      "取消原因：",
                      style: TextStyle(fontSize: 16),
                    ),
                    trailing: Text("客戶端取消"),
                  ),
                ],
              ),
            ),
          ]);
        }).toList(),
      ),
    );
  }
}