import 'dart:ui';
import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';

//文本
class TextDemo extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      color: Colors.green,
      child: Text(
        "文本",
        maxLines: 1,
        overflow: TextOverflow.ellipsis,
        //textAlign: TextAlign.center,
        textDirection: TextDirection.rtl,
        style: TextStyle(
          color: Colors.white,
        ),
      ),
    );
  }
}

//按鈕
class ButtonDemo extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        ElevatedButton(
          onPressed: () {},
          child: Text("漂浮按鈕"),
        ),
        TextButton(
          onPressed: () {},
          child: Text("扁平按鈕"),
        ),
        TextButton.icon(
          onPressed: () {},
          icon: Image.asset(
            "images/0.jpg",
            width: 30,
            height: 30,
          ),
          label: Text(
            "data",
          ),
        ),
        OutlinedButton(
          onPressed: () {},
          child: Text("OutlineButton"),
        ),
        OutlinedButton.icon(
            onPressed: () {},
            icon: Icon(Icons.abc_rounded),
            label: Text("OutlineButton.icon")),
        IconButton(
          onPressed: () {},
          icon: Icon(Icons.share),
        ),
      ],
    );
  }
}

//圖片icon
class ImageIconDemo extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Icon(Icons.add),
        IconButton(
          onPressed: () {},
          icon: Icon(Icons.add_alarm),
        ),
        Container(
          width: double.infinity,
          child: Image.network(
            "https://gimg2.baidu.com/image_search/src=http%3A%2F%2Fup.enterdesk.com%2Fedpic%2F09%2F3a%2Fbc%2F093abce7b31f4c8ffdbf345375ff4abb.jpg&refer=http%3A%2F%2Fup.enterdesk.com&app=2002&size=f9999,10000&q=a80&n=0&g=0n&fmt=auto?sec=1652583854&t=81e7f0d01114c2a9255add7319fa76c9",
            fit: BoxFit.fitWidth,
          ),
        ),
        SizedBox(
          height: 20,
        ),
        Container(
          child: Image.asset(
            "images/0.jpg",
            width: 100,
          ),
          alignment: Alignment.centerLeft,
        )
      ],
    );
  }
}

//开关复选框
class CheckDemo extends StatefulWidget {
  @override
  State<CheckDemo> createState() => _CheckDemoState();
}

class _CheckDemoState extends State<CheckDemo> {
  bool _check = false;
  bool _switch = false;
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Checkbox(
            value: _check,
            shape: CircleBorder(),
            onChanged: (v) {
              setState(() {
                _check = v!;
              });
            }),
        Switch(
            value: _switch,
            onChanged: (v) {
              setState(() {
                _switch = v;
              });
            }),
      ],
    );
  }
}

//進度指示器
class ProgressDemo extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        LinearProgressIndicator(
          //value: 1,
          valueColor: AlwaysStoppedAnimation(Color.fromARGB(255, 176, 233, 7)),
        ),
        SizedBox(
          height: 20,
        ),
        Container(
          width: 100,
          height: 100,
          child: CircularProgressIndicator(
            //value: 0.5,
            valueColor: AlwaysStoppedAnimation(Colors.blue),
          ),
        ),
        SizedBox(
          height: 20,
        ),
        CupertinoActivityIndicator(
          color: Color.fromARGB(255, 20, 2, 212),
        ),
      ],
    );
  }
}

//點擊事件
class ClickDemo extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () {
        print("tag");
      },
      onDoubleTap: () {
        print("double tag");
      },
      child: Text("點擊"),
    );
  }
}

//表单输入框
class InputDemo extends StatefulWidget {
  @override
  State<InputDemo> createState() => _InputDemoState();
}

class _InputDemoState extends State<InputDemo> {
  GlobalKey _key = GlobalKey<FormState>();
  TextEditingController _user = TextEditingController();
  TextEditingController _pass = TextEditingController();
  FocusNode _u = FocusNode();
  FocusNode _p = FocusNode();
  FocusScopeNode? _focusScopeNode;
  @override
  void dispose() {
    if (_focusScopeNode != null) {
      _focusScopeNode?.dispose();
    }
    _u.dispose();
    _p.dispose();
    _user.dispose();
    _pass.dispose();
    super.dispose();
  }

  Widget build(BuildContext context) {
    return Form(
      key: _key,
      child: Column(
        children: [
          TextFormField(
            autofocus: true,
            focusNode: _u,
            controller: _user,
            decoration: InputDecoration(
              //icon: Icon(Icons.abc),
              prefixIcon: Icon(Icons.abc),
              labelText: "username",
              hintText: "请输入用户名",
            ),
            validator: (v) {
              if (v == null || v.isEmpty) {
                return "用户名必须输入!";
              }
            },
            textInputAction: TextInputAction.next,
          ),
          SizedBox(
            height: 20,
          ),
          TextFormField(
            focusNode: _p,
            controller: _pass,
            decoration: InputDecoration(
              //icon: Icon(Icons.abc),
              prefixIcon: Icon(Icons.abc),
              labelText: "password",
              hintText: "请输入密码",
            ),
            obscureText: true,
            validator: (v) {
              if (v == null || v.length < 5) {
                return "密码必须输入且大于5";
              }
            },
            textInputAction: TextInputAction.send,
          ),
          ElevatedButton(
              onPressed: () {
                if (_focusScopeNode == null) {
                  _focusScopeNode = FocusScope.of(context);
                }
                _focusScopeNode?.requestFocus(_u); //跳到某个焦点
                //_focusScopeNode.unfocus(); //去掉焦点
                print((_key.currentState as FormState).validate().toString());
              },
              child: Text("提交")),
        ],
      ),
    );
  }
}
