/*
 * @Author: lbh
 * @Date: 2022-04-07 10:07:36
 * @LastEditors: lbh
 * @LastEditTime: 2022-04-08 12:05:00
 * @Description: file content
 */

import 'dart:html';

import 'package:flutter/material.dart';
import "./base/GlobalConfig.dart";

main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return const MaterialApp(
      home: HomePage(),
      debugShowCheckedModeBanner: false,
    );
  }
}

class HomePage extends StatefulWidget {
  const HomePage({Key? key}) : super(key: key);

  @override
  State<HomePage> createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('我的訂單'),
        titleTextStyle: const TextStyle(
          fontSize: 16.0,
          color: Colors.white,
        ),
        centerTitle: true,
        backgroundColor: GlobalConfig.themeColor,
        toolbarHeight: 46.0,
      ),
      body: DefaultTabController(
        length: 3,
        child: Scaffold(
          appBar: AppBar(
            toolbarHeight: 0.0,
            backgroundColor: Colors.white,
            bottom: TabBar(
              labelColor: GlobalConfig.themeColor,
              indicatorColor: GlobalConfig.themeColor,
              unselectedLabelColor: GlobalConfig.fontColor,
              tabs: [
                Tab(
                  text: '全部',
                ),
                Tab(
                  text: '待付款',
                ),
                Tab(
                  text: '點評/投票',
                ),
              ],
            ),
          ),
          body: const TabBarView(
            children: [
              ListViewPage(),
              ListViewPage(),
              ListViewPage(),
            ],
          ),
        ),
      ),
    );
  }
}

class ListViewPage extends StatefulWidget {
  const ListViewPage({Key? key}) : super(key: key);

  @override
  State<ListViewPage> createState() => _ListViewPageState();
}

class _ListViewPageState extends State<ListViewPage> {
  // 下拉刷新
  Future<void> _onRefresh() async {
    print("下拉刷新");
    // 持续两秒
    await Future.delayed(Duration(milliseconds: 2000), () {});
  }

  @override
  Widget build(BuildContext context) {
    return RefreshIndicator(
      child: ListView.builder(
        // 上拉加载控制器
        itemBuilder: (context, index) {
          Widget tip = const Text("");

          return Column(
            children: [
              Container(
                margin: EdgeInsets.fromLTRB(10.0, 10.0, 10.0, 0.0),
                // color: Colors.white,
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.all(
                      Radius.circular(8.0),
                    ),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                          color: Colors.grey,
                          offset: Offset(0.0, 1.0), //阴影y轴偏移量
                          blurRadius: 2.0, //阴影模糊程度
                          spreadRadius: 0 //阴影扩散程度
                          )
                    ]),
                child: Column(
                  children: [
                    ListTile(
                      // 左邊
                      leading: Image.network(
                        'https://hk-ricepon.oss-cn-hongkong.aliyuncs.com/images/member//authority/202204/1648798010297.jpeg',
                        width: 40.0,
                        height: 40.0,
                        fit: BoxFit.cover,
                      ),
                      // 標題
                      title: Row(
                        children: [
                          Text(
                            '好春光,不如夢一場!',
                            style: TextStyle(
                              fontWeight: FontWeight.w500,
                              fontSize: 14.0,
                            ),
                          ),
                          Icon(
                            Icons.arrow_forward_ios,
                            size: 12.0,
                          )
                        ],
                      ),
                      // 副標題
                      subtitle: Text(
                        '2022-4-7 16:53:19',
                        style: TextStyle(
                          fontSize: 12.0,
                        ),
                      ),
                      trailing: Text('自取 已取消'),
                    ),
                    const Divider(),
                    Container(
                      padding: EdgeInsets.fromLTRB(70.0, 0.0, 16.0, 0.0),
                      child: Row(
                        children: [
                          Text('14'),
                          Text('x1'),
                        ],
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      ),
                    ),
                    Container(
                      child: Text('共1份,總金額: \$ 14.0'),
                      alignment: Alignment.centerRight,
                      padding: EdgeInsets.all(16.0),
                    )
                  ],
                ),
              ),
              // 加载提示
              tip
            ],
          );
        },
      ),
      onRefresh: _onRefresh,
    );
  }
}
