import 'package:flutter/material.dart';

class LayoutDemo extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text("佈局類型"),
      ),
      body: Container(
        color: Colors.grey,
        /* child: Column(//豎向排列
            children: [
              Container(
                color: Colors.red,
                width: 100,
                height: 100,
              ),
              Container(
                color: Colors.green,
                width: 150,
                height: 100,
              ),
              Container(
                color: Colors.yellow,
                width: 100,
                height: 100,
              ),
            ],
          ),*/
        /*child: Row(
          //橫向排列
          //textDirection: TextDirection.ltr, //排序方式
          mainAxisSize: MainAxisSize.max,
          mainAxisAlignment: MainAxisAlignment.spaceAround,
          crossAxisAlignment: CrossAxisAlignment.stretch,
          children: [
            Container(
              color: Colors.red,
              width: 100,
              height: 200,
            ),
            Container(
              color: Colors.green,
              width: 150,
              height: 100,
            ),
            Container(
              color: Colors.yellow,
              width: 100,
              height: 100,
            ),
          ],
        ),*/
        /*child: Flex(//彈性佈局
          direction: Axis.vertical,
          children: [
            Expanded(
              child: Container(
                color: Colors.red,
                width: 100,
                height: 200,
              ),
              flex: 1,
            ),
            Expanded(
              child: Container(
                color: Colors.green,
                width: 150,
                height: 100,
              ),
              flex: 2,
            ),
            Container(
              color: Colors.yellow,
              width: 100,
              height: 100,
            ),
          ],
        ), */
        //child: wrapDemo(), //流式佈局
        child: StackDemo(), //層疊佈局
      ),
    );
  }
}

class wrapDemo extends StatefulWidget {
  @override
  State<wrapDemo> createState() => _wrapDemoState();
}

class _wrapDemoState extends State<wrapDemo> {
  List<int> list = [];
  @override
  void initState() {
    super.initState();
    for (var i = 0; i < 20; i++) {
      list.add(i);
    }
  }

  Widget build(BuildContext context) {
    return Wrap(
      direction: Axis.vertical,
      alignment: WrapAlignment.center,
      spacing: 10,
      runSpacing: 10,
      children: list
          .map((e) => Container(
                height: 100,
                width: 100,
                child: Text(e.toString()),
                color: Colors.blue,
              ))
          .toList(),
    );
  }
}

class StackDemo extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Stack(
      alignment: AlignmentDirectional.topEnd,
      children: [
        Container(
          color: Colors.green,
          width: 100,
          height: 100,
        ),
        Container(
          color: Colors.red,
          width: 50,
          height: 100,
        ),
        Positioned(
          //width: 200,
          //height: 200,
          child: Container(
            color: Colors.yellow,
          ),
          top: 10,
          bottom: 10,
          left: 10,
          right: 10,
        ),
      ],
    );
  }
}
