/*
 * @Author: lbh
 * @Date: 2022-04-07 10:07:36
 * @LastEditors: lbh
 * @LastEditTime: 2022-04-07 16:02:35
 * @Description: file content
 */

import 'package:flutter/material.dart';
import "./base/GlobalConfig.dart";

main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return const MaterialApp(
      home: HomePage(),
      debugShowCheckedModeBanner: false,
    );
  }
}

class HomePage extends StatefulWidget {
  const HomePage({Key? key}) : super(key: key);

  @override
  State<HomePage> createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('我的訂單'),
        titleTextStyle: const TextStyle(
          fontSize: 16.0,
          color: Colors.white,
        ),
        centerTitle: true,
        backgroundColor: GlobalConfig.themeColor,
        toolbarHeight: 46.0,
      ),
      body: DefaultTabController(
        length: 3,
        child: Scaffold(
          appBar: AppBar(
            toolbarHeight: 0.0,
            backgroundColor: Colors.white,
            bottom: TabBar(
              labelColor: GlobalConfig.themeColor,
              indicatorColor: GlobalConfig.themeColor,
              unselectedLabelColor: GlobalConfig.fontColor,
              tabs: [
                Tab(
                  text: '全部',
                ),
                Tab(
                  text: '待付款',
                ),
                Tab(
                  text: '點評/投票',
                ),
              ],
            ),
          ),
          body: const TabBarView(
            children: [
              ListViewPage(),
              ListViewPage(),
              ListViewPage(),
            ],
          ),
        ),
      ),
    );
  }
}

class ListViewPage extends StatefulWidget {
  const ListViewPage({Key? key}) : super(key: key);

  @override
  State<ListViewPage> createState() => _ListViewPageState();
}

class _ListViewPageState extends State<ListViewPage> {
  // 下拉刷新
  Future<void> _onRefresh() async {
    print("下拉刷新");
    // 持续两秒
    await Future.delayed(Duration(milliseconds: 2000), () {});
  }

  @override
  Widget build(BuildContext context) {
    return RefreshIndicator(
      child: ListView.builder(
          // 上拉加载控制器
          itemBuilder: (context, index) {
        Widget tip = const Text("");

        return Column(
          children: <Widget>[
            ListTile(
                title: Text(
              "10",
              maxLines: 1,
            )),
            const Divider(),
            // 加载提示
            tip
          ],
        );
      }),
      onRefresh: _onRefresh,
    );
  }
}
