/*
 * @Author: lbh
 * @Date: 2022-04-07 10:07:36
 * @LastEditors: lbh
 * @LastEditTime: 2022-04-13 16:28:24
 * @Description: file content
 */

import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:flutter_one/detail.dart';
import "./base/GlobalConfig.dart";
import 'util/DioManager.dart';

main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      initialRoute: "/",
      routes: {
        orderDetail.routeName: (context) => orderDetail(),
        HomePage.routeName: (context) => HomePage(), //注册首页路由
      },
      debugShowCheckedModeBanner: false,
    );
  }
}

class HomePage extends StatefulWidget {
  const HomePage({Key? key}) : super(key: key);
  static const String routeName = "/";
  @override
  State<HomePage> createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('我的訂單'),
        titleTextStyle: const TextStyle(
          fontSize: 16.0,
          color: Colors.white,
        ),
        centerTitle: true,
        backgroundColor: GlobalConfig.themeColor,
        toolbarHeight: 46.0,
      ),
      body: DefaultTabController(
        length: 3,
        child: Scaffold(
          appBar: AppBar(
            toolbarHeight: 0.0,
            backgroundColor: Colors.white,
            bottom: TabBar(
              labelColor: GlobalConfig.themeColor,
              indicatorColor: GlobalConfig.themeColor, //選中顏色
              unselectedLabelColor: GlobalConfig.fontColor, // 未選中顏色
              tabs: [
                Tab(
                  text: '全部',
                ),
                Tab(
                  text: '待付款',
                ),
                Tab(
                  text: '點評/投票',
                ),
              ],
            ),
          ),
          body: const TabBarView(
            children: [
              ListViewPage(),
              ListViewPage(),
              ListViewPage(),
            ],
          ),
        ),
      ),
    );
  }
}

class ListViewPage extends StatefulWidget {
  const ListViewPage({Key? key}) : super(key: key);

  @override
  State<ListViewPage> createState() => _ListViewPageState();
}

class _ListViewPageState extends State<ListViewPage> {
// 当前页数
  int _page = 1;
  // 页面数据
  List _list = [];
  // 是否还有
  bool _hasMore = true;

  // 滚动控制器
  ScrollController _scrollController = new ScrollController();
  @override
  void initState() {
    super.initState();
    this._getData();
    // 监听滚动事件
    _scrollController.addListener(() {
      // 获取滚动条下拉的距离
      // print(_scrollController.position.pixels);
      // 获取整个页面的高度
      // print(_scrollController.position.maxScrollExtent);
      if (_scrollController.position.pixels >
          _scrollController.position.maxScrollExtent - 40) {
        this._getData();
      }
    });
  }

  void _getData() async {
    if (_hasMore) {
      // ignore: prefer_collection_literals
      Map<String, dynamic> map = Map();
      map.addAll({
        'brandId': '',
        'memberId': 420132,
        'pageIndex': 1,
        'pageSize': 20,
        'restaurantId': 365
      });
      DioManager.getInstance().get(
        '/ricepon-order/api/orderInfo/getMemberOrderList',
        map,
        //正常回调
        (data) {
          setState(() {
            print('打印數據');
            print(data);
            print('第二條');
            print(json.decode(data));
            //更新UI等
            _list.addAll(json.decode(data)['data']);
          });
        },
        //错误回调
        (error) {
          print("网络异常，请稍后重试");
        },
      );
    }
  }

  // 下拉刷新
  Future<void> _onRefresh() async {
    print("下拉刷新");
    // 持续两秒
    await Future.delayed(Duration(milliseconds: 2000), () {
      _getData();
    });
  }

  Widget buildFood(foods) {
    List<Widget> tiles = [];
    Widget content;

    for (var item in foods) {
      tiles.add(
        Row(
          children: [
            Text('${item['productName']}'),
            Text('x${item['number']}'),
          ],
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
        ),
      );
    }
    //重点在这里，因为用编辑器写Column生成的children后面会跟一个<Widget>[]，
    //此时如果我们直接把生成的tiles放在<Widget>[]中是会报一个类型不匹配的错误，把<Widget>[]删了就可以了
    content = Column(children: tiles);
    return content;
  }

  @override
  Widget build(BuildContext context) {
    return RefreshIndicator(
      child: ListView.builder(
        itemCount: _list.length,
        controller: _scrollController,
        // 上拉加载控制器
        itemBuilder: (context, index) {
          return InkWell(
            onTap: () {
              print("${_list[index]}");
              Navigator.push(
                context,
                MaterialPageRoute(
                  builder: (context) => orderDetail(),
                  settings: RouteSettings(
                    name: "orderDetail",
                  ),
                ),
              );

              // Navigator.of(context).pushNamed("orderDetail");
            },
            child: Container(
              margin: EdgeInsets.fromLTRB(10.0, 10.0, 10.0, 0.0),
              // color: Colors.white,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.all(
                  Radius.circular(8.0),
                ),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                    color: Colors.grey,
                    offset: Offset(0.0, 1.0), //阴影y轴偏移量
                    blurRadius: 2.0, //阴影模糊程度
                    spreadRadius: 0, //阴影扩散程度
                  ),
                ],
              ),
              child: Column(
                children: [
                  ListTile(
                    // 左邊
                    leading: Image.network(
                      "${_list[index]['restaurantImg']}",
                      width: 40.0,
                      height: 40.0,
                      fit: BoxFit.cover,
                    ),
                    // 標題
                    title: Row(
                      children: [
                        Text(
                          '${_list[index]["restaurantName"]}',
                          style: TextStyle(
                            fontWeight: FontWeight.w500,
                            fontSize: 14.0,
                          ),
                        ),
                        Icon(
                          Icons.arrow_forward_ios,
                          size: 12.0,
                        )
                      ],
                    ),
                    // 副標題
                    subtitle: Text(
                      '${_list[index]['createTime']}',
                      style: TextStyle(
                        fontSize: 12.0,
                      ),
                    ),
                    trailing: Text('自取 已取消'),
                  ),
                  const Divider(),
                  Container(
                    child: buildFood(_list[index]['foodList']),
                    padding: EdgeInsets.fromLTRB(70.0, 0, 16.0, 0),
                  ),
                  Container(
                    child: Text(
                        '共${_list[index]["foodList"].length}份,總金額: \$ ${_list[index]['payAmount']}'),
                    alignment: Alignment.centerRight,
                    padding: EdgeInsets.all(16.0),
                  )
                ],
              ),
            ),
          );
        },
      ),
      onRefresh: _onRefresh,
    );
  }
}
