package com.gingersoft.gsa.cloud.pay.device.pos;

import android.content.Context;

import com.gingersoft.gsa.cloud.pay.Callback;
import com.gingersoft.gsa.cloud.pay.PayAction;
import com.gingersoft.gsa.cloud.pay.PayDeviceFactory;
import com.gingersoft.gsa.cloud.pay.device.pos.base.bean.BaseBgRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.base.bean.BasePosRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.YedpayCallback;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.Preconditions;

import lombok.Builder;
import lombok.Getter;

/**
 * @作者: bin
 * @創建時間: 2020-12-26 10:32
 * @更新時間: 2020-12-26 10:32
 * @描述:
 */
@Builder
@Getter
public final class PosPay {

    final Context context;
    final IView lifecycleView;
    final int payType;
    final BasePosRequest posRequest;
    final BaseBgRequest bgRequest;
    final PayAction retrievalAction;
    final Callback callback;
    final boolean showLoading;
    final long orderId;
    final String txnId;

    //yedpay所需
    final double payMoney;
    final YedpayCallback yedpayCallback;

    public void pay() {
        final PosPayAction payDevice = PayDeviceFactory.createPayDevice();
        Preconditions.checkNotNull(payDevice);
        payDevice.pay(this);
    }

    public void tip() {
        final PosPayAction payDevice = PayDeviceFactory.createPayDevice();
        Preconditions.checkNotNull(payDevice);
        payDevice.tip(this);
    }

    public void refund() {
        final PosPayAction payDevice = PayDeviceFactory.createPayDevice();
        Preconditions.checkNotNull(payDevice);
        payDevice.refund(this);
    }

    public void voidO() {
        final PosPayAction payDevice = PayDeviceFactory.createPayDevice();
        Preconditions.checkNotNull(payDevice);
        payDevice.void0(this);
    }

    public void retrieval() {
        final PosPayAction payDevice = PayDeviceFactory.createPayDevice();
        Preconditions.checkNotNull(payDevice);
        payDevice.retrieval(this);
    }

    public void printStub() {
        final PosPayAction payDevice = PayDeviceFactory.createPayDevice();
        Preconditions.checkNotNull(payDevice);
        payDevice.printStub(this);
    }

    public void settlement() {
        final PosPayAction payDevice = PayDeviceFactory.createPayDevice();
        Preconditions.checkNotNull(payDevice);
        payDevice.settlement(this);
    }
}
